/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.zookeeper.util;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstanceBuilder;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.zookeeper.ZookeeperInstance;
import org.apache.dubbo.registry.zookeeper.ZookeeperServiceDiscovery;
import org.apache.dubbo.registry.zookeeper.util.CuratorFrameworkParams;
import org.apache.dubbo.rpc.model.ScopeModelUtil;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public abstract class CuratorFrameworkUtils {
    protected static int DEFAULT_SESSION_TIMEOUT_MS = 60000;

    public static ServiceDiscovery<ZookeeperInstance> buildServiceDiscovery(CuratorFramework curatorFramework, String basePath) {
        return ServiceDiscoveryBuilder.builder(ZookeeperInstance.class).client(curatorFramework).basePath(basePath).build();
    }

    public static CuratorFramework buildCuratorFramework(URL connectionURL, ZookeeperServiceDiscovery serviceDiscovery) throws Exception {
        int sessionTimeoutMs = connectionURL.getParameter("session", DEFAULT_SESSION_TIMEOUT_MS);
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(connectionURL.getBackupAddress()).sessionTimeoutMs(sessionTimeoutMs).retryPolicy(CuratorFrameworkUtils.buildRetryPolicy(connectionURL));
        try {
            Class<?> builderClass = builder.getClass();
            Method ignore = builderClass.getMethod("ensembleTracker", Boolean.TYPE);
            boolean ensembleTrackerFlag = connectionURL.getParameter("zookeeper.ensemble.tracker", true);
            builder.ensembleTracker(ensembleTrackerFlag);
        }
        catch (Throwable builderClass) {
            // empty catch block
        }
        String userInformation = connectionURL.getUserInformation();
        if (StringUtils.isNotEmpty(userInformation)) {
            builder = builder.authorization("digest", userInformation.getBytes());
            builder.aclProvider(new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }

                public List<ACL> getAclForPath(String path) {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }
            });
        }
        CuratorFramework curatorFramework = builder.build();
        curatorFramework.start();
        curatorFramework.blockUntilConnected(((Integer)CuratorFrameworkParams.BLOCK_UNTIL_CONNECTED_WAIT.getParameterValue(connectionURL)).intValue(), (TimeUnit)((Object)CuratorFrameworkParams.BLOCK_UNTIL_CONNECTED_UNIT.getParameterValue(connectionURL)));
        if (!curatorFramework.getState().equals((Object)CuratorFrameworkState.STARTED)) {
            throw new IllegalStateException("zookeeper client initialization failed");
        }
        if (!curatorFramework.getZookeeperClient().isConnected()) {
            throw new IllegalStateException("failed to connect to zookeeper server");
        }
        return curatorFramework;
    }

    public static RetryPolicy buildRetryPolicy(URL connectionURL) {
        int baseSleepTimeMs = (Integer)CuratorFrameworkParams.BASE_SLEEP_TIME.getParameterValue(connectionURL);
        int maxRetries = (Integer)CuratorFrameworkParams.MAX_RETRIES.getParameterValue(connectionURL);
        int getMaxSleepMs = (Integer)CuratorFrameworkParams.MAX_SLEEP.getParameterValue(connectionURL);
        return new ExponentialBackoffRetry(baseSleepTimeMs, maxRetries, getMaxSleepMs);
    }

    public static List<ServiceInstance> build(URL registryUrl, Collection<org.apache.curator.x.discovery.ServiceInstance<ZookeeperInstance>> instances) {
        return instances.stream().map(i -> CuratorFrameworkUtils.build(registryUrl, (org.apache.curator.x.discovery.ServiceInstance<ZookeeperInstance>)i)).collect(Collectors.toList());
    }

    public static ServiceInstance build(URL registryUrl, org.apache.curator.x.discovery.ServiceInstance<ZookeeperInstance> instance) {
        String name = instance.getName();
        String host = instance.getAddress();
        int port = instance.getPort();
        ZookeeperInstance zookeeperInstance = (ZookeeperInstance)instance.getPayload();
        DefaultServiceInstance serviceInstance = new DefaultServiceInstance(name, host, port, ScopeModelUtil.getApplicationModel(registryUrl.getScopeModel()));
        serviceInstance.setMetadata(zookeeperInstance.getMetadata());
        return serviceInstance;
    }

    public static org.apache.curator.x.discovery.ServiceInstance<ZookeeperInstance> build(ServiceInstance serviceInstance) {
        ServiceInstanceBuilder builder;
        String serviceName = serviceInstance.getServiceName();
        String host = serviceInstance.getHost();
        int port = serviceInstance.getPort();
        SortedMap<String, String> metadata = serviceInstance.getSortedMetadata();
        String id = CuratorFrameworkUtils.generateId(host, port);
        ZookeeperInstance zookeeperInstance = new ZookeeperInstance(id, serviceName, metadata);
        try {
            builder = org.apache.curator.x.discovery.ServiceInstance.builder().id(id).name(serviceName).address(host).port(port).payload((Object)zookeeperInstance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return builder.build();
    }

    public static String generateId(String host, int port) {
        return host + ":" + port;
    }

    public static String getRootPath(URL registryURL) {
        String group = (String)CuratorFrameworkParams.ROOT_PATH.getParameterValue(registryURL);
        if (group.equalsIgnoreCase("/services") && !(group = (String)CuratorFrameworkParams.GROUP_PATH.getParameterValue(registryURL)).startsWith("/")) {
            group = "/" + group;
        }
        return group;
    }
}

