/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.h1;

import java.io.IOException;
import org.apache.dubbo.remoting.http12.HttpChannel;
import org.apache.dubbo.remoting.http12.HttpConstants;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.h1.Http1ServerChannelObserver;

public class Http1SseServerChannelObserver
extends Http1ServerChannelObserver {
    public Http1SseServerChannelObserver(HttpChannel httpChannel) {
        super(httpChannel);
    }

    @Override
    protected HttpMetadata encodeHttpMetadata(boolean endStream) {
        return super.encodeHttpMetadata(endStream).header(HttpHeaderNames.TRANSFER_ENCODING.getKey(), "chunked").header(HttpHeaderNames.CACHE_CONTROL.getKey(), "no-cache");
    }

    @Override
    protected void preOutputMessage(HttpOutputMessage message) throws IOException {
        HttpOutputMessage prefixMessage = this.getHttpChannel().newOutputMessage();
        prefixMessage.getBody().write(HttpConstants.SERVER_SENT_EVENT_DATA_PREFIX_BYTES);
        this.getHttpChannel().writeMessage(prefixMessage);
    }

    @Override
    protected void postOutputMessage(HttpOutputMessage message) throws IOException {
        HttpOutputMessage lfMessage = this.getHttpChannel().newOutputMessage();
        lfMessage.getBody().write(HttpConstants.SERVER_SENT_EVENT_LF_BYTES);
        this.getHttpChannel().writeMessage(lfMessage);
    }
}

