/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Constants;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.api.WireProtocol;
import org.apache.dubbo.remoting.api.pu.AbstractPortUnificationServer;
import org.apache.dubbo.remoting.transport.dispatcher.ChannelHandlers;
import org.apache.dubbo.remoting.transport.netty.NettyCodecAdapter;
import org.apache.dubbo.remoting.transport.netty.NettyHandler;
import org.apache.dubbo.remoting.transport.netty.NettyHelper;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

public class NettyPortUnificationServer
extends AbstractPortUnificationServer {
    private Map<String, Channel> dubboChannels = new ConcurrentHashMap<String, Channel>();
    private ServerBootstrap bootstrap;
    private org.jboss.netty.channel.Channel channel;

    public NettyPortUnificationServer(URL url, ChannelHandler handler) throws RemotingException {
        super(url, ChannelHandlers.wrap(handler, url));
    }

    @Override
    public void addSupportedProtocol(URL url, ChannelHandler handler) {
        super.addSupportedProtocol(url, ChannelHandlers.wrap(handler, url));
    }

    @Override
    public void close() {
        if (this.channel != null) {
            this.doClose();
        }
    }

    public void bind() {
        if (this.channel == null) {
            this.doOpen();
        }
    }

    @Override
    protected void doOpen0() {
        NettyHelper.setNettyLoggerFactory();
        ExecutorService boss = Executors.newCachedThreadPool(new NamedThreadFactory("NettyServerBoss", true));
        ExecutorService worker = Executors.newCachedThreadPool(new NamedThreadFactory("NettyServerWorker", true));
        NioServerSocketChannelFactory channelFactory = new NioServerSocketChannelFactory((Executor)boss, (Executor)worker, this.getUrl().getPositiveParameter("iothreads", Constants.DEFAULT_IO_THREADS));
        this.bootstrap = new ServerBootstrap((ChannelFactory)channelFactory);
        final NettyHandler nettyHandler = new NettyHandler(this.getUrl(), this);
        this.dubboChannels = nettyHandler.getChannels();
        this.bootstrap.setOption("child.tcpNoDelay", (Object)true);
        this.bootstrap.setOption("backlog", (Object)this.getUrl().getPositiveParameter("backlog", 1024));
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() {
                NettyCodecAdapter adapter = new NettyCodecAdapter(NettyPortUnificationServer.this.getCodec(), NettyPortUnificationServer.this.getUrl(), NettyPortUnificationServer.this);
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("decoder", adapter.getDecoder());
                pipeline.addLast("encoder", adapter.getEncoder());
                pipeline.addLast("handler", (org.jboss.netty.channel.ChannelHandler)nettyHandler);
                return pipeline;
            }
        });
        String bindIp = this.getUrl().getParameter("bind.ip", this.getUrl().getHost());
        int bindPort = this.getUrl().getParameter("bind.port", this.getUrl().getPort());
        if (this.getUrl().getParameter("anyhost", false) || NetUtils.isInvalidLocalHost(bindIp)) {
            bindIp = "0.0.0.0";
        }
        InetSocketAddress bindAddress = new InetSocketAddress(bindIp, bindPort);
        this.channel = this.bootstrap.bind((SocketAddress)bindAddress);
    }

    @Override
    protected void doClose() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (Throwable e) {
            this.logger.warn("6-3", "", "", e.getMessage(), e);
        }
        try {
            Collection<Channel> channels = this.getChannels();
            if (CollectionUtils.isNotEmpty(channels)) {
                for (Channel channel : channels) {
                    try {
                        channel.close();
                    }
                    catch (Throwable e) {
                        this.logger.warn("6-3", "", "", e.getMessage(), e);
                    }
                }
            }
        }
        catch (Throwable e) {
            this.logger.warn("6-3", "", "", e.getMessage(), e);
        }
        for (WireProtocol protocol : this.getProtocols().values()) {
            protocol.close();
        }
        try {
            if (this.bootstrap != null) {
                this.bootstrap.releaseExternalResources();
            }
        }
        catch (Throwable e) {
            this.logger.warn("6-3", "", "", e.getMessage(), e);
        }
        try {
            if (this.dubboChannels != null) {
                this.dubboChannels.clear();
            }
        }
        catch (Throwable e) {
            this.logger.warn("6-3", "", "", e.getMessage(), e);
        }
    }

    @Override
    protected int getChannelsSize() {
        return this.dubboChannels.size();
    }

    @Override
    public Collection<Channel> getChannels() {
        ArrayList<Channel> chs = new ArrayList<Channel>(this.dubboChannels.size());
        chs.addAll(this.dubboChannels.values());
        return chs;
    }

    @Override
    public Channel getChannel(InetSocketAddress remoteAddress) {
        return this.dubboChannels.get(NetUtils.toAddressString(remoteAddress));
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.getLocalAddress();
    }

    @Override
    public boolean isBound() {
        return this.channel.isBound();
    }
}

