/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.transport.netty4.ChannelAddressAccessor;
import org.apache.dubbo.remoting.transport.netty4.NettyChannel;
import org.apache.dubbo.rpc.model.FrameworkModel;

public final class AddressUtils {
    private static final List<ChannelAddressAccessor> ACCESSORS = FrameworkModel.defaultModel().getActivateExtensions(ChannelAddressAccessor.class);
    private static final String LOCAL_ADDRESS_KEY = "NETTY_LOCAL_ADDRESS_KEY";
    private static final String REMOTE_ADDRESS_KEY = "NETTY_REMOTE_ADDRESS_KEY";
    private static final String PROTOCOL_KEY = "NETTY_PROTOCOL_KEY";

    private AddressUtils() {
    }

    public static InetSocketAddress getRemoteAddress(Channel channel) {
        int size = ACCESSORS.size();
        for (int i = 0; i < size; ++i) {
            InetSocketAddress address = ACCESSORS.get(i).getRemoteAddress(channel);
            if (address == null) continue;
            return address;
        }
        return (InetSocketAddress)channel.remoteAddress();
    }

    public static InetSocketAddress getLocalAddress(Channel channel) {
        int size = ACCESSORS.size();
        for (int i = 0; i < size; ++i) {
            InetSocketAddress address = ACCESSORS.get(i).getLocalAddress(channel);
            if (address == null) continue;
            return address;
        }
        return (InetSocketAddress)channel.localAddress();
    }

    static void initAddressIfNecessary(NettyChannel nettyChannel) {
        Channel channel = nettyChannel.getNioChannel();
        SocketAddress address = channel.localAddress();
        if (address instanceof InetSocketAddress) {
            return;
        }
        int size = ACCESSORS.size();
        for (int i = 0; i < size; ++i) {
            ChannelAddressAccessor accessor = ACCESSORS.get(i);
            InetSocketAddress localAddress = accessor.getLocalAddress(channel);
            if (localAddress == null) continue;
            nettyChannel.setAttribute(LOCAL_ADDRESS_KEY, localAddress);
            nettyChannel.setAttribute(REMOTE_ADDRESS_KEY, accessor.getRemoteAddress(channel));
            nettyChannel.setAttribute(PROTOCOL_KEY, accessor.getProtocol());
            break;
        }
    }

    static InetSocketAddress getLocalAddress(NettyChannel channel) {
        InetSocketAddress address = (InetSocketAddress)channel.getAttribute(LOCAL_ADDRESS_KEY);
        return address == null ? (InetSocketAddress)channel.getNioChannel().localAddress() : address;
    }

    static InetSocketAddress getRemoteAddress(NettyChannel channel) {
        InetSocketAddress address = (InetSocketAddress)channel.getAttribute(REMOTE_ADDRESS_KEY);
        return address == null ? (InetSocketAddress)channel.getNioChannel().remoteAddress() : address;
    }

    static String getLocalAddressKey(NettyChannel channel) {
        InetSocketAddress address = AddressUtils.getLocalAddress(channel);
        if (address == null) {
            return "UNKNOWN";
        }
        String protocol = (String)channel.getAttribute(PROTOCOL_KEY);
        return protocol == null ? NetUtils.toAddressString(address) : protocol + ' ' + NetUtils.toAddressString(address);
    }

    static String getRemoteAddressKey(NettyChannel channel) {
        InetSocketAddress address = AddressUtils.getRemoteAddress(channel);
        if (address == null) {
            return "UNKNOWN";
        }
        String protocol = (String)channel.getAttribute(PROTOCOL_KEY);
        return protocol == null ? NetUtils.toAddressString(address) : protocol + ' ' + NetUtils.toAddressString(address);
    }
}

