/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.AttributeKey;
import java.util.List;
import javax.net.ssl.SSLSession;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.ssl.AuthPolicy;
import org.apache.dubbo.common.ssl.CertManager;
import org.apache.dubbo.common.ssl.ProviderCert;
import org.apache.dubbo.remoting.transport.netty4.ssl.SslContexts;

public class SslServerTlsHandler
extends ByteToMessageDecoder {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(SslServerTlsHandler.class);
    private final URL url;
    private final boolean sslDetected;
    private static final AttributeKey<SSLSession> SSL_SESSION_KEY = AttributeKey.valueOf((String)"ssl-session");

    public SslServerTlsHandler(URL url) {
        this.url = url;
        this.sslDetected = false;
    }

    public SslServerTlsHandler(URL url, boolean sslDetected) {
        this.url = url;
        this.sslDetected = sslDetected;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error("99-0", "unknown error in remoting module", "", "TLS negotiation failed when trying to accept new connection.", cause);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
            if (handshakeEvent.isSuccess()) {
                SSLSession session = ((SslHandler)ctx.pipeline().get(SslHandler.class)).engine().getSession();
                logger.info("TLS negotiation succeed with: " + session.getPeerHost());
                ctx.pipeline().remove((ChannelHandler)this);
                ctx.channel().attr(SSL_SESSION_KEY).set((Object)session);
            } else {
                logger.error("99-0", "", "", "TLS negotiation failed when trying to accept new connection.", handshakeEvent.cause());
                ctx.close();
            }
        }
        super.userEventTriggered(ctx, evt);
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        if (byteBuf.readableBytes() < 5) {
            return;
        }
        if (this.sslDetected) {
            return;
        }
        CertManager certManager = this.url.getOrDefaultFrameworkModel().getBeanFactory().getBean(CertManager.class);
        ProviderCert providerConnectionConfig = certManager.getProviderConnectionConfig(this.url, channelHandlerContext.channel().remoteAddress());
        if (providerConnectionConfig == null) {
            channelHandlerContext.pipeline().remove((ChannelHandler)this);
            return;
        }
        if (this.isSsl(byteBuf)) {
            SslContext sslContext = SslContexts.buildServerSslContext(providerConnectionConfig);
            this.enableSsl(channelHandlerContext, sslContext);
            return;
        }
        if (providerConnectionConfig.getAuthPolicy() == AuthPolicy.NONE) {
            channelHandlerContext.pipeline().remove((ChannelHandler)this);
            return;
        }
        logger.error("99-0", "", "", "TLS negotiation failed when trying to accept new connection.");
        channelHandlerContext.close();
    }

    private boolean isSsl(ByteBuf buf) {
        return SslHandler.isEncrypted((ByteBuf)buf);
    }

    private void enableSsl(ChannelHandlerContext ctx, SslContext sslContext) {
        ChannelPipeline p = ctx.pipeline();
        ctx.pipeline().addAfter(ctx.name(), null, (ChannelHandler)sslContext.newHandler(ctx.alloc()));
        p.addLast("unificationA", (ChannelHandler)new SslServerTlsHandler(this.url, true));
        p.remove((ChannelHandler)this);
    }
}

