/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.websocket;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.dubbo.remoting.http12.CompositeInputStream;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.message.StreamingDecoder;
import org.apache.dubbo.remoting.websocket.FinalFragment;

public class FinalFragmentStreamingDecoder
implements StreamingDecoder {
    private boolean inDelivery;
    private boolean pendingDelivery;
    private boolean closed;
    private boolean closing;
    protected final CompositeInputStream accumulate = new CompositeInputStream();
    protected StreamingDecoder.FragmentListener listener;

    @Override
    public void request(int numMessages) {
    }

    @Override
    public void decode(InputStream inputStream) throws DecodeException {
        if (this.closing || this.closed) {
            return;
        }
        this.accumulate.addInputStream(inputStream);
        if (inputStream instanceof FinalFragment && ((FinalFragment)((Object)inputStream)).isFinalFragment()) {
            this.pendingDelivery = true;
            this.deliver();
        }
    }

    @Override
    public void close() {
        this.closing = true;
        this.deliver();
    }

    @Override
    public void onStreamClosed() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.accumulate.close();
        }
        catch (IOException e) {
            throw new DecodeException(e);
        }
    }

    @Override
    public void setFragmentListener(StreamingDecoder.FragmentListener listener) {
        this.listener = listener;
    }

    private void deliver() {
        if (this.inDelivery) {
            return;
        }
        if (this.closed) {
            return;
        }
        this.inDelivery = true;
        try {
            if (this.pendingDelivery) {
                this.processBody();
                this.pendingDelivery = false;
            }
            if (this.closing && !this.closed) {
                this.closed = true;
                this.accumulate.close();
                this.listener.onClose();
            }
        }
        catch (IOException e) {
            throw new DecodeException(e);
        }
        finally {
            this.inDelivery = false;
        }
    }

    private void processBody() throws IOException {
        byte[] rawMessage = this.readRawMessage(this.accumulate, this.accumulate.available());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(rawMessage);
        this.invokeListener(inputStream);
    }

    protected void invokeListener(InputStream inputStream) {
        this.listener.onFragmentMessage(inputStream);
    }

    protected byte[] readRawMessage(InputStream inputStream, int length) throws IOException {
        byte[] data = new byte[length];
        inputStream.read(data, 0, length);
        return data;
    }
}

