/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.websocket.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.h2.Http2Header;
import org.apache.dubbo.remoting.http12.h2.Http2InputMessageFrame;
import org.apache.dubbo.remoting.http12.h2.Http2MetadataFrame;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessage;
import org.apache.dubbo.remoting.http12.netty4.h1.NettyHttp1HttpHeaders;
import org.apache.dubbo.remoting.websocket.FinalFragmentByteBufInputStream;
import org.apache.dubbo.remoting.websocket.WebSocketHeaderNames;

public class WebSocketFrameCodec
extends ChannelDuplexHandler {
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof BinaryWebSocketFrame || msg instanceof TextWebSocketFrame) {
            Http2InputMessageFrame http2InputMessage = this.onDataFrame((WebSocketFrame)msg);
            super.channelRead(ctx, (Object)http2InputMessage);
        } else if (msg instanceof CloseWebSocketFrame) {
            Object closeMessage = this.onCloseFrame((CloseWebSocketFrame)msg);
            super.channelRead(ctx, closeMessage);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof Http2OutputMessage) {
            WebSocketFrame webSocketFrame = this.encodeWebSocketFrame(ctx, (Http2OutputMessage)msg);
            super.write(ctx, (Object)webSocketFrame, promise);
        } else if (msg instanceof Http2Header) {
            Http2Header http2Header = (Http2Header)msg;
            if (http2Header.isEndStream()) {
                CloseWebSocketFrame closeWebSocketFrame = this.encodeCloseWebSocketFrame(http2Header);
                super.write(ctx, (Object)closeWebSocketFrame, promise);
            }
        } else {
            super.write(ctx, msg, promise);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof WebSocketServerProtocolHandler.HandshakeComplete) {
            Http2Header http2Header = this.onHandshakeComplete((WebSocketServerProtocolHandler.HandshakeComplete)evt);
            super.channelRead(ctx, (Object)http2Header);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    private Http2Header onHandshakeComplete(WebSocketServerProtocolHandler.HandshakeComplete evt) {
        NettyHttp1HttpHeaders httpHeaders = new NettyHttp1HttpHeaders(evt.requestHeaders());
        httpHeaders.set((CharSequence)HttpHeaderNames.PATH.getName(), evt.requestUri());
        httpHeaders.set((CharSequence)HttpHeaderNames.METHOD.getName(), HttpMethods.POST.name());
        return new Http2MetadataFrame(httpHeaders);
    }

    private Http2InputMessageFrame onDataFrame(WebSocketFrame webSocketFrame) {
        ByteBuf data = webSocketFrame.content();
        return new Http2InputMessageFrame((InputStream)((Object)new FinalFragmentByteBufInputStream(data, true, webSocketFrame.isFinalFragment())), false);
    }

    private Object onCloseFrame(CloseWebSocketFrame closeWebSocketFrame) {
        if (closeWebSocketFrame.statusCode() != WebSocketCloseStatus.NORMAL_CLOSURE.code()) {
            return new DefaultHttp2ResetFrame((long)closeWebSocketFrame.statusCode());
        }
        return new Http2InputMessageFrame(StreamUtils.EMPTY, true);
    }

    private CloseWebSocketFrame encodeCloseWebSocketFrame(Http2Header http2Header) {
        HttpHeaders headers = http2Header.headers();
        List<String> statusHeaders = headers.remove(HttpHeaderNames.STATUS.getName());
        WebSocketCloseStatus status = WebSocketCloseStatus.NORMAL_CLOSURE;
        if (CollectionUtils.isNotEmpty(statusHeaders) && !HttpStatus.OK.getStatusString().equals(statusHeaders.get(0))) {
            List<String> messageHeaders = headers.remove(WebSocketHeaderNames.WEBSOCKET_MESSAGE.getName());
            status = new WebSocketCloseStatus(WebSocketCloseStatus.INTERNAL_SERVER_ERROR.code(), CollectionUtils.isNotEmpty(messageHeaders) ? messageHeaders.get(0) : WebSocketCloseStatus.INTERNAL_SERVER_ERROR.reasonText());
        }
        return new CloseWebSocketFrame(status);
    }

    private WebSocketFrame encodeWebSocketFrame(ChannelHandlerContext ctx, Http2OutputMessage outputMessage) throws IOException {
        OutputStream body = outputMessage.getBody();
        if (body == null) {
            return new BinaryWebSocketFrame();
        }
        if (body instanceof ByteBufOutputStream) {
            ByteBuf buffer = ((ByteBufOutputStream)body).buffer();
            return new BinaryWebSocketFrame(buffer);
        }
        throw new IllegalArgumentException("Http2OutputMessage body must be ByteBufOutputStream");
    }
}

