/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.zookeeper.curator5;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.zookeeper.curator5.Curator5ZookeeperClient;
import org.apache.dubbo.remoting.zookeeper.curator5.ZookeeperClient;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ZookeeperClientManager {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ZookeeperClientManager.class);
    private final Map<String, ZookeeperClient> zookeeperClientMap = new ConcurrentHashMap<String, ZookeeperClient>();
    private static final Map<ApplicationModel, ZookeeperClientManager> managerMap = new ConcurrentHashMap<ApplicationModel, ZookeeperClientManager>();

    public static ZookeeperClientManager getInstance(ApplicationModel applicationModel) {
        if (!managerMap.containsKey(applicationModel) || managerMap.get(applicationModel) == null) {
            ZookeeperClientManager clientManager = new ZookeeperClientManager();
            applicationModel.addDestroyListener(m -> {
                try {
                    clientManager.destroy();
                }
                catch (Exception e) {
                    logger.error("6-12", "", "", "Error encountered while destroying ZookeeperTransporter: " + e.getMessage(), e);
                }
            });
            managerMap.put(applicationModel, clientManager);
        }
        return managerMap.get(applicationModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZookeeperClient connect(URL url) {
        List<String> addressList = this.getURLBackupAddress(url);
        ZookeeperClient zookeeperClient = this.fetchAndUpdateZookeeperClientCache(addressList);
        if (zookeeperClient != null && zookeeperClient.isConnected()) {
            logger.info("find valid zookeeper client from the cache for address: " + url);
            return zookeeperClient;
        }
        Map<String, ZookeeperClient> map = this.zookeeperClientMap;
        synchronized (map) {
            zookeeperClient = this.fetchAndUpdateZookeeperClientCache(addressList);
            if (zookeeperClient != null && zookeeperClient.isConnected()) {
                logger.info("find valid zookeeper client from the cache for address: " + url);
                return zookeeperClient;
            }
            zookeeperClient = new Curator5ZookeeperClient(url);
            logger.info("No valid zookeeper client found from cache, therefore create a new client for url. " + url);
            this.writeToClientMap(addressList, zookeeperClient);
        }
        return zookeeperClient;
    }

    public ZookeeperClient fetchAndUpdateZookeeperClientCache(List<String> addressList) {
        String address;
        ZookeeperClient zookeeperClient = null;
        Iterator<String> iterator = addressList.iterator();
        while (iterator.hasNext() && ((zookeeperClient = this.zookeeperClientMap.get(address = iterator.next())) == null || !zookeeperClient.isConnected())) {
        }
        if (zookeeperClient != null && zookeeperClient.isConnected()) {
            this.writeToClientMap(addressList, zookeeperClient);
        }
        return zookeeperClient;
    }

    public List<String> getURLBackupAddress(URL url) {
        ArrayList<String> addressList = new ArrayList<String>();
        addressList.add(url.getAddress());
        addressList.addAll(url.getParameter("backup", Collections.emptyList()));
        String authPrefix = null;
        if (StringUtils.isNotEmpty(url.getUsername())) {
            StringBuilder buf = new StringBuilder();
            buf.append(url.getUsername());
            if (StringUtils.isNotEmpty(url.getPassword())) {
                buf.append(':');
                buf.append(url.getPassword());
            }
            buf.append('@');
            authPrefix = buf.toString();
        }
        if (StringUtils.isNotEmpty(authPrefix)) {
            ArrayList<String> authedAddressList = new ArrayList<String>(addressList.size());
            for (String addr : addressList) {
                authedAddressList.add(authPrefix + addr);
            }
            return authedAddressList;
        }
        return addressList;
    }

    void writeToClientMap(List<String> addressList, ZookeeperClient zookeeperClient) {
        for (String address : addressList) {
            this.zookeeperClientMap.put(address, zookeeperClient);
        }
    }

    URL toClientURL(URL url) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (url.getParameter("timeout") != null) {
            parameterMap.put("timeout", url.getParameter("timeout"));
        }
        if (url.getParameter("backup") != null) {
            parameterMap.put("backup", url.getParameter("backup"));
        }
        return new ServiceConfigURL(url.getProtocol(), url.getUsername(), url.getPassword(), url.getHost(), url.getPort(), ZookeeperClientManager.class.getName(), parameterMap);
    }

    public Map<String, ZookeeperClient> getZookeeperClientMap() {
        return this.zookeeperClientMap;
    }

    public void destroy() {
        for (ZookeeperClient client : this.zookeeperClientMap.values()) {
            client.close();
        }
        this.zookeeperClientMap.clear();
    }
}

