/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.BaseServiceMetadata;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.cluster.filter.FilterChainBuilder;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceMetadata;
import org.apache.dubbo.rpc.protocol.dubbo.ChannelWrappedInvoker;
import org.apache.dubbo.rpc.protocol.dubbo.DubboProtocol;
import org.apache.dubbo.rpc.support.RpcUtils;

public class CallbackServiceCodec {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(CallbackServiceCodec.class);
    private static final byte CALLBACK_NONE = 0;
    private static final byte CALLBACK_CREATE = 1;
    private static final byte CALLBACK_DESTROY = 2;
    private static final String INV_ATT_CALLBACK_KEY = "sys_callback_arg-";
    private final ProxyFactory proxyFactory;
    private final Protocol protocolSPI;
    private final FrameworkModel frameworkModel;
    private final DubboProtocol dubboProtocol;

    public CallbackServiceCodec(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.proxyFactory = frameworkModel.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
        this.protocolSPI = frameworkModel.getExtensionLoader(Protocol.class).getExtension("dubbo");
        this.dubboProtocol = (DubboProtocol)frameworkModel.getExtensionLoader(Protocol.class).getExtension("dubbo", false);
    }

    private static byte isCallBack(URL url, String protocolServiceKey, String methodName, int argIndex) {
        String callback;
        int isCallback = 0;
        if (url != null && url.hasServiceMethodParameter(protocolServiceKey, methodName) && (callback = url.getServiceParameter(protocolServiceKey, methodName + "." + argIndex + ".callback")) != null) {
            if ("true".equalsIgnoreCase(callback)) {
                isCallback = 1;
            } else if ("false".equalsIgnoreCase(callback)) {
                isCallback = 2;
            }
        }
        return (byte)isCallback;
    }

    private String exportOrUnexportCallbackService(Channel channel, RpcInvocation inv, URL url, Class clazz, Object inst, Boolean export) throws IOException {
        Map<String, String> parameters;
        String group;
        int instid = System.identityHashCode(inst);
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("isserver", Boolean.FALSE.toString());
        params.put("is_callback_service", Boolean.TRUE.toString());
        String string = group = inv == null ? null : (String)inv.getObjectAttachmentWithoutConvert("group");
        if (group != null && group.length() > 0) {
            params.put("group", group);
        }
        params.put("methods", StringUtils.join(ClassUtils.getDeclaredMethodNames(clazz), ","));
        HashMap<String, String> tmpMap = new HashMap<String, String>();
        if (url != null && (parameters = url.getParameters()) != null && !parameters.isEmpty()) {
            tmpMap.putAll(parameters);
        }
        tmpMap.putAll(params);
        tmpMap.remove("version");
        tmpMap.remove("bind.port");
        tmpMap.put("interface", clazz.getName());
        URL exportUrl = new ServiceConfigURL("dubbo", channel.getLocalAddress().getAddress().getHostAddress(), channel.getLocalAddress().getPort(), clazz.getName() + "." + instid, tmpMap);
        String cacheKey = CallbackServiceCodec.getClientSideCallbackServiceCacheKey(instid);
        String countKey = CallbackServiceCodec.getClientSideCountKey(clazz.getName());
        if (export.booleanValue()) {
            if (!channel.hasAttribute(cacheKey) && !CallbackServiceCodec.isInstancesOverLimit(channel, url, clazz.getName(), instid, false)) {
                ModuleModel moduleModel;
                if (inv.getServiceModel() == null) {
                    moduleModel = ApplicationModel.defaultModel().getDefaultModule();
                    logger.error("4-18", "", "", "Unable to get Service Model from Invocation. Please check if your invocation failed! This error only happen in UT cases! Invocation:" + inv);
                } else {
                    moduleModel = inv.getServiceModel().getModuleModel();
                }
                ServiceDescriptor serviceDescriptor = moduleModel.getServiceRepository().registerService(clazz);
                ServiceMetadata serviceMetadata = new ServiceMetadata(clazz.getName() + "." + instid, exportUrl.getGroup(), exportUrl.getVersion(), clazz);
                String serviceKey = BaseServiceMetadata.buildServiceKey(exportUrl.getPath(), group, exportUrl.getVersion());
                ProviderModel providerModel = new ProviderModel(serviceKey, inst, serviceDescriptor, moduleModel, serviceMetadata, ClassUtils.getClassLoader(clazz));
                moduleModel.getServiceRepository().registerProvider(providerModel);
                exportUrl = exportUrl.setScopeModel(moduleModel);
                exportUrl = exportUrl.setServiceModel(providerModel);
                Invoker<Object> invoker = this.proxyFactory.getInvoker(inst, clazz, exportUrl);
                Exporter<Object> exporter = this.protocolSPI.export(invoker);
                channel.setAttribute(cacheKey, exporter);
                logger.info("Export a callback service :" + exportUrl + ", on " + channel + ", url is: " + url);
                CallbackServiceCodec.increaseInstanceCount(channel, countKey);
            }
        } else if (channel.hasAttribute(cacheKey)) {
            Exporter exporter = (Exporter)channel.getAttribute(cacheKey);
            exporter.unexport();
            channel.removeAttribute(cacheKey);
            CallbackServiceCodec.decreaseInstanceCount(channel, countKey);
        }
        return String.valueOf(instid);
    }

    private Object referOrDestroyCallbackService(Channel channel, URL url, Class<?> clazz, Invocation inv, int instid, boolean isRefer) {
        String invokerCacheKey = CallbackServiceCodec.getServerSideCallbackInvokerCacheKey(channel, clazz.getName(), instid);
        String proxyCacheKey = CallbackServiceCodec.getServerSideCallbackServiceCacheKey(channel, clazz.getName(), instid);
        Object proxy = channel.getAttribute(proxyCacheKey);
        String countkey = CallbackServiceCodec.getServerSideCountKey(channel, clazz.getName());
        if (isRefer) {
            if (proxy == null) {
                URL referurl = URL.valueOf("callback://" + url.getAddress() + "/" + clazz.getName() + "?" + "interface" + "=" + clazz.getName());
                if (!CallbackServiceCodec.isInstancesOverLimit(channel, referurl = referurl.addParametersIfAbsent(url.getParameters()).removeParameter("methods").addParameter("side", "consumer"), clazz.getName(), instid, true)) {
                    url.getOrDefaultApplicationModel().getDefaultModule().getServiceRepository().registerService(clazz);
                    Invoker<?> invoker = new ChannelWrappedInvoker(clazz, channel, referurl, String.valueOf(instid));
                    FilterChainBuilder builder = this.getFilterChainBuilder(url);
                    invoker = builder.buildInvokerChain(invoker, "reference.filter", "consumer");
                    invoker = builder.buildInvokerChain(invoker, "reference.filter", "callback");
                    proxy = this.proxyFactory.getProxy(invoker);
                    channel.setAttribute(proxyCacheKey, proxy);
                    channel.setAttribute(invokerCacheKey, invoker);
                    CallbackServiceCodec.increaseInstanceCount(channel, countkey);
                    ConcurrentHashSet callbackInvokers = (ConcurrentHashSet)channel.getAttribute("channel.callback.invokers.key");
                    if (callbackInvokers == null) {
                        callbackInvokers = new ConcurrentHashSet(1);
                        channel.setAttribute("channel.callback.invokers.key", callbackInvokers);
                    }
                    callbackInvokers.add(invoker);
                    logger.info("method " + RpcUtils.getMethodName(inv) + " include a callback service :" + invoker.getUrl() + ", a proxy :" + invoker + " has been created.");
                }
            }
        } else if (proxy != null) {
            Invoker invoker = (Invoker)channel.getAttribute(invokerCacheKey);
            try {
                Set callbackInvokers = (Set)channel.getAttribute("channel.callback.invokers.key");
                if (callbackInvokers != null) {
                    callbackInvokers.remove(invoker);
                }
                invoker.destroy();
            }
            catch (Exception e) {
                logger.error("4-17", "", "", e.getMessage(), e);
            }
            channel.removeAttribute(proxyCacheKey);
            channel.removeAttribute(invokerCacheKey);
            CallbackServiceCodec.decreaseInstanceCount(channel, countkey);
        }
        return proxy;
    }

    private FilterChainBuilder getFilterChainBuilder(URL url) {
        return ScopeModelUtil.getExtensionLoader(FilterChainBuilder.class, url.getScopeModel()).getDefaultExtension();
    }

    private static String getClientSideCallbackServiceCacheKey(int instid) {
        return "callback.service.instid." + instid;
    }

    private static String getServerSideCallbackServiceCacheKey(Channel channel, String interfaceClass, int instid) {
        return "callback.service.proxy." + System.identityHashCode(channel) + "." + interfaceClass + "." + instid;
    }

    private static String getServerSideCallbackInvokerCacheKey(Channel channel, String interfaceClass, int instid) {
        return CallbackServiceCodec.getServerSideCallbackServiceCacheKey(channel, interfaceClass, instid) + ".invoker";
    }

    private static String getClientSideCountKey(String interfaceClass) {
        return "callback.service.instid." + interfaceClass + ".COUNT";
    }

    private static String getServerSideCountKey(Channel channel, String interfaceClass) {
        return "callback.service.proxy." + System.identityHashCode(channel) + "." + interfaceClass + ".COUNT";
    }

    private static boolean isInstancesOverLimit(Channel channel, URL url, String interfaceClass, int instid, boolean isServer) {
        Integer count = (Integer)channel.getAttribute(isServer ? CallbackServiceCodec.getServerSideCountKey(channel, interfaceClass) : CallbackServiceCodec.getClientSideCountKey(interfaceClass));
        int limit = url.getParameter("callbacks", 1);
        if (count != null && count >= limit) {
            throw new IllegalStateException("interface " + interfaceClass + " `s callback instances num exceed providers limit :" + limit + " ,current num: " + (count + 1) + ". The new callback service will not work !!! you can cancel the callback service which exported before. channel :" + channel);
        }
        return false;
    }

    private static void increaseInstanceCount(Channel channel, String countkey) {
        try {
            Integer count = (Integer)channel.getAttribute(countkey);
            if (count == null) {
                count = 1;
            } else {
                Integer n = count;
                count = count + 1;
            }
            channel.setAttribute(countkey, count);
        }
        catch (Exception e) {
            logger.error("0-2", "", "", e.getMessage(), e);
        }
    }

    private static void decreaseInstanceCount(Channel channel, String countkey) {
        try {
            Integer count = (Integer)channel.getAttribute(countkey);
            if (count == null || count <= 0) {
                return;
            }
            Integer n = count;
            count = count - 1;
            channel.setAttribute(countkey, count);
        }
        catch (Exception e) {
            logger.error("0-2", "", "", e.getMessage(), e);
        }
    }

    public Object encodeInvocationArgument(Channel channel, RpcInvocation inv, int paraIndex) throws IOException {
        URL url = inv.getInvoker() == null ? null : inv.getInvoker().getUrl();
        byte callbackStatus = CallbackServiceCodec.isCallBack(url, inv.getProtocolServiceKey(), RpcUtils.getMethodName(inv), paraIndex);
        Object[] args = inv.getArguments();
        Class<?>[] pts = inv.getParameterTypes();
        switch (callbackStatus) {
            case 1: {
                inv.setAttachment(INV_ATT_CALLBACK_KEY + paraIndex, this.exportOrUnexportCallbackService(channel, inv, url, pts[paraIndex], args[paraIndex], true));
                return null;
            }
            case 2: {
                inv.setAttachment(INV_ATT_CALLBACK_KEY + paraIndex, this.exportOrUnexportCallbackService(channel, inv, url, pts[paraIndex], args[paraIndex], false));
                return null;
            }
        }
        return args[paraIndex];
    }

    public Object decodeInvocationArgument(Channel channel, RpcInvocation inv, Class<?>[] pts, int paraIndex, Object inObject) throws IOException {
        URL url = null;
        try {
            url = this.dubboProtocol.getInvoker(channel, inv).getUrl();
        }
        catch (RemotingException e) {
            if (logger.isInfoEnabled()) {
                logger.info(e.getMessage(), e);
            }
            return inObject;
        }
        byte callbackstatus = CallbackServiceCodec.isCallBack(url, inv.getProtocolServiceKey(), RpcUtils.getMethodName(inv), paraIndex);
        switch (callbackstatus) {
            case 1: {
                try {
                    return this.referOrDestroyCallbackService(channel, url, pts[paraIndex], inv, Integer.parseInt(inv.getAttachment(INV_ATT_CALLBACK_KEY + paraIndex)), true);
                }
                catch (Exception e) {
                    logger.error("4-17", "", "", e.getMessage(), e);
                    throw new IOException(StringUtils.toString(e));
                }
            }
            case 2: {
                try {
                    return this.referOrDestroyCallbackService(channel, url, pts[paraIndex], inv, Integer.parseInt(inv.getAttachment(INV_ATT_CALLBACK_KEY + paraIndex)), false);
                }
                catch (Exception e) {
                    throw new IOException(StringUtils.toString(e));
                }
            }
        }
        return inObject;
    }
}

