/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.remoting.http12.exception.UnimplementedException;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.protocol.tri.TripleCustomerProtocolWrapper;
import org.apache.dubbo.rpc.service.ServiceDescriptorInternalCache;
import org.apache.dubbo.rpc.stub.StubSuppliers;

public final class DescriptorUtils {
    private DescriptorUtils() {
    }

    public static ServiceDescriptor findServiceDescriptor(Invoker<?> invoker, String serviceName, boolean hasStub) throws UnimplementedException {
        ServiceDescriptor result = hasStub ? DescriptorUtils.getStubServiceDescriptor(invoker.getUrl(), serviceName) : DescriptorUtils.getReflectionServiceDescriptor(invoker.getUrl());
        if (result == null) {
            throw new UnimplementedException("service:" + serviceName);
        }
        return result;
    }

    public static ServiceDescriptor getStubServiceDescriptor(URL url, String serviceName) {
        ServiceDescriptor serviceDescriptor = url.getServiceModel() != null ? url.getServiceModel().getServiceModel() : StubSuppliers.getServiceDescriptor(serviceName);
        return serviceDescriptor;
    }

    public static ServiceDescriptor getReflectionServiceDescriptor(URL url) {
        ProviderModel providerModel = (ProviderModel)url.getServiceModel();
        if (providerModel == null || providerModel.getServiceModel() == null) {
            return null;
        }
        return providerModel.getServiceModel();
    }

    public static MethodDescriptor findMethodDescriptor(ServiceDescriptor serviceDescriptor, String originalMethodName, boolean hasStub) throws UnimplementedException {
        MethodDescriptor result = hasStub ? serviceDescriptor.getMethods(originalMethodName).get(0) : DescriptorUtils.findReflectionMethodDescriptor(serviceDescriptor, originalMethodName);
        return result;
    }

    public static MethodDescriptor findReflectionMethodDescriptor(ServiceDescriptor serviceDescriptor, String methodName) {
        MethodDescriptor methodDescriptor = null;
        if (DescriptorUtils.isGeneric(methodName)) {
            methodDescriptor = ServiceDescriptorInternalCache.genericService().getMethods(methodName).get(0);
        } else {
            if (DescriptorUtils.isEcho(methodName)) {
                return ServiceDescriptorInternalCache.echoService().getMethods(methodName).get(0);
            }
            List<MethodDescriptor> methodDescriptors = serviceDescriptor.getMethods(methodName);
            if (CollectionUtils.isEmpty(methodDescriptors)) {
                String lowerMethod = Character.toLowerCase(methodName.charAt(0)) + methodName.substring(1);
                methodDescriptors = serviceDescriptor.getMethods(lowerMethod);
            }
            if (CollectionUtils.isEmpty(methodDescriptors)) {
                return null;
            }
            if (methodDescriptors.size() == 1) {
                methodDescriptor = methodDescriptors.get(0);
            }
            if (methodDescriptors.size() == 2) {
                if (methodDescriptors.get(1).getRpcType() == MethodDescriptor.RpcType.SERVER_STREAM) {
                    methodDescriptor = methodDescriptors.get(0);
                } else if (methodDescriptors.get(0).getRpcType() == MethodDescriptor.RpcType.SERVER_STREAM) {
                    methodDescriptor = methodDescriptors.get(1);
                }
            }
        }
        return methodDescriptor;
    }

    public static MethodDescriptor findTripleMethodDescriptor(ServiceDescriptor serviceDescriptor, String methodName, InputStream rawMessage) throws IOException {
        MethodDescriptor methodDescriptor = DescriptorUtils.findReflectionMethodDescriptor(serviceDescriptor, methodName);
        if (methodDescriptor == null) {
            byte[] data = StreamUtils.readBytes(rawMessage);
            List<MethodDescriptor> methodDescriptors = serviceDescriptor.getMethods(methodName);
            TripleCustomerProtocolWrapper.TripleRequestWrapper request = TripleCustomerProtocolWrapper.TripleRequestWrapper.parseFrom(data);
            Object[] paramTypes = request.getArgTypes().toArray(new String[0]);
            for (MethodDescriptor descriptor : methodDescriptors) {
                if (!Arrays.equals(descriptor.getCompatibleParamSignatures(), paramTypes)) continue;
                methodDescriptor = descriptor;
                break;
            }
            if (methodDescriptor == null) {
                throw new UnimplementedException("method:" + methodName);
            }
            rawMessage.reset();
        }
        return methodDescriptor;
    }

    private static boolean isGeneric(String methodName) {
        return "$invoke".equals(methodName) || "$invokeAsync".equals(methodName);
    }

    private static boolean isEcho(String methodName) {
        return "$echo".equals(methodName);
    }
}

