/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.incubator.codec.http3.Http3ServerConnectionHandler;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.logger.FluentLogger;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.RemotingServer;
import org.apache.dubbo.remoting.api.connection.AbstractConnectionClient;
import org.apache.dubbo.remoting.http12.netty4.HttpWriteQueueHandler;
import org.apache.dubbo.remoting.http3.netty4.NettyHttp3FrameCodec;
import org.apache.dubbo.remoting.http3.netty4.NettyHttp3ProtocolSelectorHandler;
import org.apache.dubbo.remoting.transport.ChannelHandlerAdapter;
import org.apache.dubbo.remoting.transport.netty4.NettyHttp3Server;
import org.apache.dubbo.remoting.utils.UrlUtils;
import org.apache.dubbo.rpc.model.ScopeModelUtil;
import org.apache.dubbo.rpc.protocol.tri.TriplePingPongHandler;
import org.apache.dubbo.rpc.protocol.tri.h3.Http3ClientFrameCodec;
import org.apache.dubbo.rpc.protocol.tri.h3.Http3TripleServerConnectionHandler;
import org.apache.dubbo.rpc.protocol.tri.h3.negotiation.Helper;

public final class Http3Exchanger {
    private static final FluentLogger LOGGER = FluentLogger.of(Http3Exchanger.class);
    private static final boolean HAS_NETTY_HTTP3 = ClassUtils.isPresent("io.netty.incubator.codec.http3.Http3");
    private static final Map<String, RemotingServer> SERVERS = new ConcurrentHashMap<String, RemotingServer>();
    private static final Map<String, AbstractConnectionClient> CLIENTS = new ConcurrentHashMap<String, AbstractConnectionClient>(16);
    private static final org.apache.dubbo.remoting.ChannelHandler HANDLER = new ChannelHandlerAdapter();
    private static boolean ENABLED = false;
    private static boolean NEGOTIATION_ENABLED = true;

    private Http3Exchanger() {
    }

    public static void init(Configuration configuration) {
        ENABLED = configuration.getBoolean("dubbo.protocol.triple.http3.enabled", false);
        NEGOTIATION_ENABLED = configuration.getBoolean("dubbo.protocol.triple.http3.negotiation", true);
        if (ENABLED && !HAS_NETTY_HTTP3) {
            throw new IllegalStateException("Class for netty http3 support not found");
        }
    }

    public static boolean isEnabled(URL url) {
        return ENABLED || HAS_NETTY_HTTP3 && url.getParameter("http3", false);
    }

    public static RemotingServer bind(URL url) {
        if (Http3Exchanger.isEnabled(url)) {
            return SERVERS.computeIfAbsent(url.getAddress(), addr -> {
                try {
                    URL serverUrl = url.putAttribute("http3PipelineConfigurator", Http3Exchanger.configServerPipeline(url));
                    return new NettyHttp3Server(serverUrl, HANDLER);
                }
                catch (RemotingException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return null;
    }

    private static Consumer<ChannelPipeline> configServerPipeline(URL url) {
        final NettyHttp3ProtocolSelectorHandler selectorHandler = new NettyHttp3ProtocolSelectorHandler(url, ScopeModelUtil.getFrameworkModel(url.getScopeModel()));
        return pipeline -> {
            pipeline.addLast(new ChannelHandler[]{new Http3ServerConnectionHandler((ChannelHandler)new ChannelInitializer<QuicStreamChannel>(){

                protected void initChannel(QuicStreamChannel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpWriteQueueHandler()}).addLast(new ChannelHandler[]{new FlushConsolidationHandler(64, true)}).addLast(new ChannelHandler[]{NettyHttp3FrameCodec.INSTANCE}).addLast(new ChannelHandler[]{selectorHandler});
                }
            })});
            pipeline.addLast(new ChannelHandler[]{new Http3TripleServerConnectionHandler()});
        };
    }

    public static AbstractConnectionClient connect(URL url) {
        return CLIENTS.compute(url.getAddress(), (address, client) -> {
            if (client == null) {
                URL clientUrl = url.putAttribute("http3PipelineConfigurator", Http3Exchanger.configClientPipeline(url));
                AbstractConnectionClient connectionClient = NEGOTIATION_ENABLED ? Helper.createAutoSwitchClient(clientUrl, HANDLER) : Helper.createHttp3Client(clientUrl, HANDLER);
                connectionClient.addCloseListener(() -> CLIENTS.remove(address, connectionClient));
                client = connectionClient;
            } else {
                client.retain();
            }
            return client;
        });
    }

    private static Consumer<ChannelPipeline> configClientPipeline(URL url) {
        int heartbeat = UrlUtils.getHeartbeat(url);
        int closeTimeout = UrlUtils.getCloseTimeout(url);
        return pipeline -> {
            pipeline.addLast(new ChannelHandler[]{Http3ClientFrameCodec.INSTANCE});
            pipeline.addLast(new ChannelHandler[]{new IdleStateHandler((long)heartbeat, 0L, 0L, TimeUnit.MILLISECONDS)});
            pipeline.addLast(new ChannelHandler[]{new TriplePingPongHandler(closeTimeout)});
        };
    }

    public static void close() {
        if (SERVERS.isEmpty()) {
            return;
        }
        ArrayList<RemotingServer> toClose = new ArrayList<RemotingServer>(SERVERS.values());
        SERVERS.clear();
        for (RemotingServer server : toClose) {
            try {
                server.close();
            }
            catch (Throwable t) {
                LOGGER.error("4-8", "Close http3 server failed", t);
            }
        }
    }
}

