/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.http2;

import java.util.Map;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2ServerChannelObserver;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.ServerStreamObserver;
import org.apache.dubbo.rpc.protocol.tri.TripleProtocol;
import org.apache.dubbo.rpc.protocol.tri.compressor.Compressor;
import org.apache.dubbo.rpc.protocol.tri.h12.AttachmentHolder;
import org.apache.dubbo.rpc.protocol.tri.h12.CompressibleEncoder;
import org.apache.dubbo.rpc.protocol.tri.stream.StreamUtils;

public class Http2ServerStreamObserver
extends Http2ServerChannelObserver
implements ServerStreamObserver<Object>,
AttachmentHolder {
    private final FrameworkModel frameworkModel;
    private Map<String, Object> attachments;

    public Http2ServerStreamObserver(FrameworkModel frameworkModel, H2StreamChannel h2StreamChannel) {
        super(h2StreamChannel);
        this.frameworkModel = frameworkModel;
    }

    @Override
    public void setCompression(String compression) {
        CompressibleEncoder compressibleEncoder = new CompressibleEncoder(this.getResponseEncoder());
        compressibleEncoder.setCompressor(Compressor.getCompressor(this.frameworkModel, compression));
        this.setResponseEncoder(compressibleEncoder);
    }

    @Override
    public void setResponseAttachments(Map<String, Object> attachments) {
        this.attachments = attachments;
    }

    @Override
    public Map<String, Object> getResponseAttachments() {
        return this.attachments;
    }

    @Override
    protected HttpMetadata encodeTrailers(Throwable throwable) {
        HttpMetadata metadata = super.encodeTrailers(throwable);
        HttpHeaders headers = metadata.headers();
        StreamUtils.putHeaders(headers, this.attachments, TripleProtocol.CONVERT_NO_LOWER_HEADER);
        return metadata;
    }
}

