/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h12.http2;

import java.io.IOException;
import org.apache.dubbo.remoting.http12.HttpConstants;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessage;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.h12.http2.Http2StreamServerChannelObserver;

public final class Http2SseServerChannelObserver
extends Http2StreamServerChannelObserver {
    public Http2SseServerChannelObserver(FrameworkModel frameworkModel, H2StreamChannel h2StreamChannel) {
        super(frameworkModel, h2StreamChannel);
    }

    @Override
    protected HttpMetadata encodeHttpMetadata(boolean endStream) {
        return super.encodeHttpMetadata(endStream).header(HttpHeaderNames.CACHE_CONTROL.getKey(), "no-cache");
    }

    @Override
    protected void preOutputMessage(HttpOutputMessage message) throws IOException {
        Http2OutputMessage prefixMessage = ((H2StreamChannel)this.getHttpChannel()).newOutputMessage();
        prefixMessage.getBody().write(HttpConstants.SERVER_SENT_EVENT_DATA_PREFIX_BYTES);
        ((H2StreamChannel)this.getHttpChannel()).writeMessage(prefixMessage);
    }

    @Override
    protected void postOutputMessage(HttpOutputMessage message) throws IOException {
        Http2OutputMessage lfMessage = ((H2StreamChannel)this.getHttpChannel()).newOutputMessage();
        lfMessage.getBody().write(HttpConstants.SERVER_SENT_EVENT_LF_BYTES);
        ((H2StreamChannel)this.getHttpChannel()).writeMessage(lfMessage);
    }
}

