/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.argument;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.rest.ParamType;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.RestParameterException;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.NamedValueMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

public abstract class NamedValueArgumentResolverSupport {
    protected final Map<ParameterMeta, NamedValueMeta> cache = CollectionUtils.newConcurrentHashMap();

    protected final Object resolve(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        Class<?> type = meta.type();
        if (type.isArray() || Collection.class.isAssignableFrom(type)) {
            return this.resolveCollectionValue(meta, request, response);
        }
        if (Map.class.isAssignableFrom(type)) {
            return this.resolveMapValue(meta, request, response);
        }
        Object arg = this.resolveValue(meta, request, response);
        if (arg != null) {
            return this.filterValue(arg, meta);
        }
        arg = meta.defaultValue();
        if (arg != null) {
            return arg;
        }
        if (meta.required()) {
            throw new RestParameterException(Messages.ARGUMENT_VALUE_MISSING, meta.name(), type);
        }
        return null;
    }

    protected final NamedValueMeta updateNamedValueMeta(ParameterMeta parameter, NamedValueMeta meta) {
        if (meta.isNameEmpty()) {
            meta.setName(parameter.getName());
        }
        if (meta.paramType() == null) {
            meta.setParamType(this.getParamType(meta));
        }
        Class<?> type = parameter.getActualType();
        meta.setType(type);
        meta.setGenericType(parameter.getActualGenericType());
        if (type.isArray()) {
            meta.setNestedTypes(new Class[]{type});
        } else {
            meta.setNestedTypes(TypeUtils.getNestedActualTypes(meta.genericType()));
        }
        meta.setParameter(parameter);
        return meta;
    }

    protected ParamType getParamType(NamedValueMeta meta) {
        return null;
    }

    protected String emptyDefaultValue(NamedValueMeta meta) {
        return meta.defaultValue();
    }

    protected abstract Object resolveValue(NamedValueMeta var1, HttpRequest var2, HttpResponse var3);

    protected Object filterValue(Object value, NamedValueMeta meta) {
        return value;
    }

    protected Object resolveCollectionValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        return this.resolveValue(meta, request, response);
    }

    protected Object resolveMapValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        Map<String, Object> value = this.resolveValue(meta, request, response);
        return value instanceof Map ? value : Collections.singletonMap(meta.name(), value);
    }
}

