/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.Condition;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.NameValueExpression;

public final class HeadersCondition
implements Condition<HeadersCondition, HttpRequest> {
    private final Set<NameValueExpression> expressions;

    public HeadersCondition(String ... headers) {
        LinkedHashSet<NameValueExpression> expressions = null;
        if (headers != null) {
            for (String header : headers) {
                NameValueExpression expr = NameValueExpression.parse(header);
                String name = expr.getName();
                if (HttpHeaderNames.ACCEPT.getName().equalsIgnoreCase(name) || HttpHeaderNames.CONTENT_TYPE.getName().equalsIgnoreCase(name)) continue;
                if (expressions == null) {
                    expressions = new LinkedHashSet<NameValueExpression>();
                }
                expressions.add(expr);
            }
        }
        this.expressions = expressions == null ? Collections.emptySet() : expressions;
    }

    private HeadersCondition(Set<NameValueExpression> expressions) {
        this.expressions = expressions;
    }

    @Override
    public HeadersCondition combine(HeadersCondition other) {
        LinkedHashSet<NameValueExpression> set = new LinkedHashSet<NameValueExpression>(this.expressions);
        set.addAll(other.expressions);
        return new HeadersCondition(set);
    }

    @Override
    public HeadersCondition match(HttpRequest request) {
        for (NameValueExpression expression : this.expressions) {
            if (expression.match(request::hasHeader, request::header)) continue;
            return null;
        }
        return this;
    }

    @Override
    public int compareTo(HeadersCondition other, HttpRequest request) {
        return other.expressions.size() - this.expressions.size();
    }

    public int hashCode() {
        return this.expressions.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != HeadersCondition.class) {
            return false;
        }
        return this.expressions.equals(((HeadersCondition)obj).expressions);
    }

    public String toString() {
        return "HeadersCondition{headers=" + this.expressions + '}';
    }
}

