/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationSupport;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.MethodMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.util.PathUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestToolKit;

public final class ServiceMeta
extends AnnotationSupport {
    private final List<Class<?>> hierarchy;
    private final Class<?> type;
    private final Object service;
    private final ServiceDescriptor serviceDescriptor;
    private final URL url;
    private final String contextPath;
    private List<MethodMeta> exceptionHandlers;

    public ServiceMeta(Collection<Class<?>> hierarchy, ServiceDescriptor serviceDescriptor, Object service, URL url, RestToolKit toolKit) {
        super(toolKit);
        this.hierarchy = new ArrayList(hierarchy);
        this.serviceDescriptor = serviceDescriptor;
        this.type = this.hierarchy.get(0);
        this.service = service;
        this.url = url;
        this.contextPath = PathUtils.getContextPath(url);
    }

    public List<Class<?>> getHierarchy() {
        return this.hierarchy;
    }

    public Class<?> getType() {
        return this.type;
    }

    public ServiceDescriptor getServiceDescriptor() {
        return this.serviceDescriptor;
    }

    public Object getService() {
        return this.service;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getServiceInterface() {
        return this.url.getServiceInterface();
    }

    public String getServiceGroup() {
        return this.url.getGroup();
    }

    public String getServiceVersion() {
        return this.url.getVersion();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public List<MethodMeta> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    @Override
    public List<? extends AnnotatedElement> getAnnotatedElements() {
        return this.hierarchy;
    }

    @Override
    protected AnnotatedElement getAnnotatedElement() {
        return this.hierarchy.get(0);
    }

    public String toString() {
        String version;
        String group;
        StringBuilder sb = new StringBuilder(64);
        sb.append("ServiceMeta{interface=").append(this.getServiceInterface()).append(", service=").append(this.toShortString());
        if (StringUtils.isNotEmpty(this.contextPath)) {
            sb.append(", contextPath='").append(this.contextPath).append('\'');
        }
        if (StringUtils.isNotEmpty(group = this.getServiceGroup())) {
            sb.append(", group='").append(group).append('\'');
        }
        if (StringUtils.isNotEmpty(version = this.getServiceVersion())) {
            sb.append(", version='").append(version).append('\'');
        }
        sb.append('}');
        return sb.toString();
    }

    public String toShortString() {
        return this.type.getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(this.service));
    }

    public void addExceptionHandler(MethodMeta methodMeta) {
        if (this.exceptionHandlers == null) {
            this.exceptionHandlers = new ArrayList<MethodMeta>();
        }
        this.exceptionHandlers.add(methodMeta);
    }
}

