/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.dubbo.common.config.CompositeConfiguration;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.utils.Pair;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.nested.OpenAPIConfig;
import org.apache.dubbo.rpc.model.FrameworkModel;

public final class ConfigFactory {
    private static Map<String, Method> CONFIG_METHODS;
    private final FrameworkModel frameworkModel;
    private volatile Map<String, OpenAPIConfig> configMap;

    public ConfigFactory(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    private static Environment getEnvironment(FrameworkModel frameworkModel) {
        return frameworkModel.defaultApplication().modelEnvironment();
    }

    public OpenAPIConfig getConfig(String group) {
        return this.getConfigMap().get(group);
    }

    public OpenAPIConfig getGlobalConfig() {
        return this.getConfigMap().get("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, OpenAPIConfig> getConfigMap() {
        if (this.configMap == null) {
            ConfigFactory configFactory = this;
            synchronized (configFactory) {
                if (this.configMap == null) {
                    this.configMap = this.readConfigMap();
                }
            }
        }
        return this.configMap;
    }

    private Map<String, OpenAPIConfig> readConfigMap() {
        HashMap<String, OpenAPIConfig> map = new HashMap<String, OpenAPIConfig>();
        Environment environment = ConfigFactory.getEnvironment(this.frameworkModel);
        CompositeConfiguration configuration = environment.getConfiguration();
        List<Map<String, String>> configMaps = environment.getConfigurationMaps();
        HashSet<String> allKeys = new HashSet<String>();
        for (Map<String, String> configMap : configMaps) {
            for (String string : configMap.keySet()) {
                if (!string.startsWith("dubbo.protocol.triple.rest.openapi")) continue;
                allKeys.add(string);
            }
        }
        int len = "dubbo.protocol.triple.rest.openapi".length();
        HashMap<Pair, TreeMap> valuesMap = new HashMap<Pair, TreeMap>();
        for (String string : allKeys) {
            String key;
            String group;
            if (string.length() <= len) continue;
            char c = string.charAt(len);
            if (c == '.') {
                group = "";
                key = string.substring(len + 1);
            } else {
                if (c != 's') continue;
                int end = string.indexOf(46, len + 1);
                group = string.substring(len + 1, end);
                key = string.substring(end + 1);
            }
            int brkStart = key.lastIndexOf(91);
            if (brkStart > 0) {
                try {
                    String value = configuration.getString(string);
                    if (StringUtils.isEmpty(value)) continue;
                    int index = Integer.parseInt(key.substring(brkStart + 1, key.length() - 1));
                    valuesMap.computeIfAbsent(Pair.of(group, key.substring(0, brkStart)), k -> new TreeMap()).put(index, value);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            ConfigFactory.applyConfigValue(map, group, key, configuration.getString(string));
        }
        for (Map.Entry entry : valuesMap.entrySet()) {
            Pair pair = (Pair)entry.getKey();
            String value = StringUtils.join(((TreeMap)entry.getValue()).values(), ",");
            ConfigFactory.applyConfigValue(map, (String)pair.getKey(), (String)pair.getValue(), value);
        }
        map.computeIfAbsent("", k -> new OpenAPIConfig());
        return map;
    }

    private static void applyConfigValue(Map<String, OpenAPIConfig> map, String group, String key, String value) {
        Method method;
        if (value == null || value.isEmpty()) {
            return;
        }
        OpenAPIConfig config = map.computeIfAbsent(group, k -> new OpenAPIConfig());
        int index = key.indexOf("settings.");
        if (index == 0) {
            Map<String, String> settings = config.getSettings();
            if (settings == null) {
                settings = new HashMap<String, String>();
                config.setSettings(settings);
            }
            settings.put(key.substring(9), value);
            return;
        }
        Map<String, Method> configMethods = CONFIG_METHODS;
        if (configMethods == null) {
            configMethods = new HashMap<String, Method>();
            for (Method method2 : OpenAPIConfig.class.getMethods()) {
                String name = ConfigFactory.toConfigName(method2);
                if (name == null) continue;
                configMethods.put(name, method2);
            }
            CONFIG_METHODS = configMethods;
        }
        if ((method = configMethods.get(key)) == null) {
            return;
        }
        Class<?> valueType = method.getParameterTypes()[0];
        try {
            if (valueType == String.class) {
                method.invoke((Object)config, value);
            } else if (valueType == Boolean.class) {
                method.invoke((Object)config, StringUtils.toBoolean(value, false));
            } else if (valueType.isArray()) {
                method.invoke((Object)config, new Object[]{StringUtils.tokenize(value, new char[0])});
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String toConfigName(Method method) {
        if (method.getParameterCount() != 1) {
            return null;
        }
        String name = method.getName();
        if (!name.startsWith("set")) {
            return null;
        }
        int len = name.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 3; i < len; ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 3) {
                    sb.append('-');
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

