/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi;

import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.logger.FluentLogger;
import org.apache.dubbo.common.logger.Level;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.utils.LRUCache;
import org.apache.dubbo.common.utils.Pair;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.HttpResult;
import org.apache.dubbo.remoting.http12.exception.HttpResultPayloadException;
import org.apache.dubbo.remoting.http12.rest.OpenAPIRequest;
import org.apache.dubbo.remoting.http12.rest.OpenAPIService;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.ExceptionUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RadixTree;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.Registration;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMappingRegistry;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.HandlerMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ServiceMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.ConfigFactory;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.DefinitionEncoder;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.DefinitionFilter;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.DefinitionMerger;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.DefinitionResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.ExtensionFactory;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Helper;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.OpenAPIDocumentPublisher;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.OpenAPIRequestHandler;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.OpenAPI;
import org.apache.dubbo.rpc.protocol.tri.rest.util.PathUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;

public class DefaultOpenAPIService
implements OpenAPIRequestHandler,
OpenAPIService {
    private static final FluentLogger LOG = FluentLogger.of(DefaultOpenAPIService.class);
    private static final String API_DOCS = "/api-docs";
    private final LRUCache<String, SoftReference<String>> cache = new LRUCache(64);
    private final FrameworkModel frameworkModel;
    private final ConfigFactory configFactory;
    private final ExtensionFactory extensionFactory;
    private final DefinitionResolver definitionResolver;
    private final DefinitionMerger definitionMerger;
    private final DefinitionFilter definitionFilter;
    private final DefinitionEncoder definitionEncoder;
    private final RadixTree<OpenAPIRequestHandler> tree;
    private volatile List<OpenAPI> openAPIs;
    private boolean exported;
    private ScheduledFuture<?> exportFuture;

    public DefaultOpenAPIService(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.configFactory = frameworkModel.getOrRegisterBean(ConfigFactory.class);
        this.extensionFactory = frameworkModel.getOrRegisterBean(ExtensionFactory.class);
        this.definitionResolver = new DefinitionResolver(frameworkModel);
        this.definitionMerger = new DefinitionMerger(frameworkModel);
        this.definitionFilter = new DefinitionFilter(frameworkModel);
        this.definitionEncoder = new DefinitionEncoder(frameworkModel);
        this.tree = this.initRequestHandlers();
    }

    private RadixTree<OpenAPIRequestHandler> initRequestHandlers() {
        RadixTree<OpenAPIRequestHandler> tree = new RadixTree<OpenAPIRequestHandler>(false);
        for (OpenAPIRequestHandler handler : (OpenAPIRequestHandler[])this.extensionFactory.getExtensions(OpenAPIRequestHandler.class)) {
            for (String path : handler.getPaths()) {
                tree.addPath(path, handler);
            }
        }
        tree.addPath(this, API_DOCS, "/api-docs/{group}");
        return tree;
    }

    @Override
    public HttpResult<?> handle(String path, HttpRequest httpRequest, HttpResponse httpResponse) {
        OpenAPIRequest request = (OpenAPIRequest)httpRequest.attribute(OpenAPIRequest.class.getName());
        String group = RequestUtils.getPathVariable(httpRequest, "group");
        if (group != null) {
            request.setGroup(StringUtils.substringBeforeLast(group, 46));
        }
        return HttpResult.builder().contentType("application/" + request.getFormat()).body(this.handleDocument(request, httpRequest).getBytes(StandardCharsets.UTF_8)).build();
    }

    @Override
    public Collection<String> getOpenAPIGroups() {
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        groups.add("default");
        for (OpenAPI openAPI : this.getOpenAPIs()) {
            groups.add(openAPI.getGroup());
            openAPI.walkOperations(operation -> {
                String group = operation.getGroup();
                if (StringUtils.isNotEmpty(group)) {
                    groups.add(group);
                }
            });
        }
        return groups;
    }

    public OpenAPI getOpenAPI(OpenAPIRequest request) {
        return this.definitionFilter.filter(this.definitionMerger.merge(this.getOpenAPIs(), request), request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OpenAPI> getOpenAPIs() {
        if (this.openAPIs == null) {
            DefaultOpenAPIService defaultOpenAPIService = this;
            synchronized (defaultOpenAPIService) {
                if (this.openAPIs == null) {
                    this.openAPIs = this.resolveOpenAPIs();
                }
            }
        }
        return this.openAPIs;
    }

    private List<OpenAPI> resolveOpenAPIs() {
        RequestMappingRegistry registry = this.frameworkModel.getBean(RequestMappingRegistry.class);
        if (registry == null) {
            return Collections.emptyList();
        }
        HashMap<Key, Map> byClassMap = new HashMap<Key, Map>();
        for (Registration registration : registry.getRegistrations()) {
            HandlerMeta meta = registration.getMeta();
            byClassMap.computeIfAbsent(new Key(meta.getService()), k -> new IdentityHashMap()).computeIfAbsent(meta.getMethod().getMethod(), k -> new ArrayList(1)).add(registration);
        }
        ArrayList<OpenAPI> openAPIs = new ArrayList<OpenAPI>(byClassMap.size());
        for (Map.Entry entry : byClassMap.entrySet()) {
            OpenAPI openAPI = this.definitionResolver.resolve(((Key)entry.getKey()).serviceMeta, ((Map)entry.getValue()).values());
            if (openAPI == null) continue;
            openAPIs.add(openAPI);
        }
        openAPIs.sort(Comparator.comparingInt(OpenAPI::getPriority));
        return openAPIs;
    }

    @Override
    public String getDocument(OpenAPIRequest request) {
        String path = null;
        try {
            request = Helper.formatRequest(request);
            HttpRequest httpRequest = RpcContext.getServiceContext().getRequest(HttpRequest.class);
            if (!RequestUtils.isRestRequest(httpRequest)) {
                return this.handleDocument(request, null);
            }
            path = RequestUtils.getPathVariable(httpRequest, "path");
            if (StringUtils.isEmpty(path)) {
                String url = PathUtils.join(httpRequest.path(), "swagger-ui/index.html");
                throw HttpResult.found(url).toPayload();
            }
            path = '/' + path;
            List<RadixTree.Match<OpenAPIRequestHandler>> matches = this.tree.matchRelaxed(path);
            if (matches.isEmpty()) {
                throw HttpResult.notFound().toPayload();
            }
            Collections.sort(matches);
            RadixTree.Match<OpenAPIRequestHandler> match = matches.get(0);
            HttpResponse httpResponse = RpcContext.getServiceContext().getResponse(HttpResponse.class);
            if (request.getFormat() == null) {
                request.setFormat(Helper.parseFormat(httpResponse.contentType()));
            }
            httpRequest.setAttribute(OpenAPIRequest.class.getName(), request);
            httpRequest.setAttribute("org.springframework.web.servlet.HandlerMapping.uriTemplateVariables", match.getVariableMap());
            throw match.getValue().handle(path, httpRequest, httpResponse).toPayload();
        }
        catch (HttpResultPayloadException e) {
            throw e;
        }
        catch (Throwable t) {
            Level level = ExceptionUtils.resolveLogLevel(ExceptionUtils.unwrap(t));
            LOG.log(level, "Failed to processing OpenAPI request {} for path: '{}'", request, path, t);
            throw t;
        }
    }

    private String handleDocument(OpenAPIRequest request, HttpRequest httpRequest) {
        String value;
        String host;
        if (Boolean.FALSE.equals(this.configFactory.getGlobalConfig().getCache())) {
            return this.definitionEncoder.encode(this.getOpenAPI(request), request);
        }
        StringBuilder sb = new StringBuilder();
        if (httpRequest != null && (host = httpRequest.serverHost()) != null) {
            String referer = httpRequest.header("referer");
            sb.append(referer != null && referer.contains(host) ? Character.valueOf('/') : host);
        }
        sb.append('|').append(request.toString());
        String cacheKey = sb.toString();
        SoftReference<String> ref = this.cache.get(cacheKey);
        if (ref != null && (value = ref.get()) != null) {
            return value;
        }
        value = this.definitionEncoder.encode(this.getOpenAPI(request), request);
        this.cache.put(cacheKey, new SoftReference<String>(value));
        return value;
    }

    @Override
    public void refresh() {
        LOG.debug("Refreshing OpenAPI documents");
        this.openAPIs = null;
        this.cache.clear();
        if (this.exported) {
            this.export();
        }
    }

    @Override
    public void export() {
        if (!this.extensionFactory.hasExtensions(OpenAPIDocumentPublisher.class)) {
            return;
        }
        try {
            if (this.exportFuture != null) {
                this.exportFuture.cancel(false);
            }
            this.exportFuture = this.frameworkModel.getBean(FrameworkExecutorRepository.class).getMetadataRetryExecutor().schedule(this::doExport, 30L, TimeUnit.SECONDS);
            this.exported = true;
        }
        catch (Throwable t) {
            LOG.internalWarn("Failed to export OpenAPI documents", t);
        }
    }

    private void doExport() {
        for (OpenAPIDocumentPublisher publisher : (OpenAPIDocumentPublisher[])this.extensionFactory.getExtensions(OpenAPIDocumentPublisher.class)) {
            try {
                publisher.publish(request -> {
                    OpenAPI openAPI = this.getOpenAPI((OpenAPIRequest)request);
                    String document = this.definitionEncoder.encode(openAPI, (OpenAPIRequest)request);
                    return Pair.of(openAPI, document);
                });
            }
            catch (Throwable t) {
                LOG.internalWarn("Failed to publish OpenAPI document by {}", publisher, t);
            }
        }
        this.exportFuture = null;
    }

    private static final class Key {
        private final ServiceMeta serviceMeta;

        public Key(ServiceMeta serviceMeta) {
            this.serviceMeta = serviceMeta;
        }

        public boolean equals(Object obj) {
            return this.serviceMeta.getType() == ((Key)obj).serviceMeta.getType();
        }

        public int hashCode() {
            return this.serviceMeta.getType().hashCode();
        }
    }
}

