/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi.model;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Context;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Node;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Schema;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.SecurityScheme;

public final class Components
extends Node<Components> {
    private Map<String, Schema> schemas;
    private Map<String, SecurityScheme> securitySchemes;

    public Map<String, Schema> getSchemas() {
        return this.schemas;
    }

    public Components setSchemas(Map<String, Schema> schemas) {
        this.schemas = schemas;
        return this;
    }

    public Components addSchema(String name, Schema schema) {
        if (this.schemas == null) {
            this.schemas = new TreeMap<String, Schema>();
        }
        this.schemas.put(name, schema);
        return this;
    }

    public Components removeSchema(String name) {
        if (this.schemas != null) {
            this.schemas.remove(name);
        }
        return this;
    }

    public Map<String, SecurityScheme> getSecuritySchemes() {
        return this.securitySchemes;
    }

    public Components setSecuritySchemes(Map<String, SecurityScheme> securitySchemes) {
        this.securitySchemes = securitySchemes;
        return this;
    }

    public Components addSecurityScheme(String name, SecurityScheme securityScheme) {
        if (this.securitySchemes == null) {
            this.securitySchemes = new LinkedHashMap<String, SecurityScheme>();
        }
        this.securitySchemes.put(name, securityScheme);
        return this;
    }

    public Components removeSecurityScheme(String name) {
        if (this.securitySchemes != null) {
            this.securitySchemes.remove(name);
        }
        return this;
    }

    @Override
    public Components clone() {
        Components clone = (Components)super.clone();
        clone.schemas = Components.clone(this.schemas);
        clone.securitySchemes = Components.clone(this.securitySchemes);
        return clone;
    }

    @Override
    public Map<String, Object> writeTo(Map<String, Object> node, Context context) {
        Components.write(node, "schemas", this.schemas, context);
        Components.write(node, "securitySchemes", this.securitySchemes, context);
        this.writeExtensions(node);
        return node;
    }
}

