/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Context;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Node;

public final class OAuthFlow
extends Node<OAuthFlow> {
    private String authorizationUrl;
    private String tokenUrl;
    private String refreshUrl;
    private Map<String, String> scopes;

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public OAuthFlow setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
        return this;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public OAuthFlow setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
        return this;
    }

    public String getRefreshUrl() {
        return this.refreshUrl;
    }

    public OAuthFlow setRefreshUrl(String refreshUrl) {
        this.refreshUrl = refreshUrl;
        return this;
    }

    public Map<String, String> getScopes() {
        return this.scopes;
    }

    public OAuthFlow setScopes(Map<String, String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public OAuthFlow addScope(String name, String description) {
        if (this.scopes == null) {
            this.scopes = new LinkedHashMap<String, String>();
        }
        this.scopes.put(name, description);
        return this;
    }

    public void removeScope(String name) {
        if (this.scopes != null) {
            this.scopes.remove(name);
        }
    }

    @Override
    public OAuthFlow clone() {
        OAuthFlow clone = (OAuthFlow)super.clone();
        if (this.scopes != null) {
            clone.scopes = new LinkedHashMap<String, String>(this.scopes);
        }
        return clone;
    }

    @Override
    public Map<String, Object> writeTo(Map<String, Object> node, Context context) {
        OAuthFlow.write(node, "authorizationUrl", this.authorizationUrl);
        OAuthFlow.write(node, "tokenUrl", this.tokenUrl);
        OAuthFlow.write(node, "refreshUrl", this.refreshUrl);
        OAuthFlow.write(node, "scopes", this.scopes);
        this.writeExtensions(node);
        return node;
    }
}

