/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs;

import java.io.OutputStream;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import org.apache.dubbo.remoting.http12.HttpCookie;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.MultivaluedMapWrapper;

public final class JaxrsHttpResponseAdapter
implements org.jboss.resteasy.spi.HttpResponse {
    private final HttpResponse response;
    private MultivaluedMap<String, Object> headers;

    public JaxrsHttpResponseAdapter(HttpResponse response) {
        this.response = response;
    }

    public int getStatus() {
        return this.response.status();
    }

    public void setStatus(int status) {
        this.response.setStatus(status);
    }

    public MultivaluedMap<String, Object> getOutputHeaders() {
        Object headers = this.headers;
        if (headers == null) {
            this.headers = headers = new MultivaluedMapWrapper(this.response.headers());
        }
        return headers;
    }

    public OutputStream getOutputStream() {
        return this.response.outputStream();
    }

    public void setOutputStream(OutputStream os) {
        this.response.setOutputStream(os);
    }

    public void addNewCookie(NewCookie cookie) {
        HttpCookie hCookie = new HttpCookie(cookie.getName(), cookie.getValue());
        hCookie.setDomain(cookie.getDomain());
        hCookie.setPath(cookie.getPath());
        hCookie.setMaxAge(cookie.getMaxAge());
        hCookie.setSecure(cookie.isSecure());
        hCookie.setHttpOnly(cookie.isHttpOnly());
        this.response.addCookie(hCookie);
    }

    public void sendError(int status) {
        this.response.sendError(status);
    }

    public void sendError(int status, String message) {
        this.response.sendError(status, message);
    }

    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    public void reset() {
        this.response.reset();
    }

    public void flushBuffer() {
    }
}

