/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;

final class ParamConverterFactory {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ParamConverterFactory.class);
    private final Map<List<Object>, Optional<ParamConverter<?>>> cache = CollectionUtils.newConcurrentHashMap();
    private final List<ParamConverterProvider> providers = new ArrayList<ParamConverterProvider>();

    ParamConverterFactory() {
        Iterator<ParamConverterProvider> it = ServiceLoader.load(ParamConverterProvider.class).iterator();
        while (it.hasNext()) {
            try {
                this.providers.add(it.next());
            }
            catch (Throwable t) {
                logger.error("0-15", "", "", "Failed to load ParamConverterProvider", t);
            }
        }
    }

    public <T> ParamConverter<T> getParamConverter(Class<T> type, Type genericType, Annotation[] annotations) {
        if (this.providers.isEmpty()) {
            return null;
        }
        ArrayList<Type> key = new ArrayList<Type>(annotations.length + 2);
        key.add(type);
        key.add(genericType);
        Collections.addAll(key, annotations);
        return this.cache.computeIfAbsent(key, k -> {
            for (ParamConverterProvider provider : this.providers) {
                ParamConverter converter = provider.getConverter(type, genericType, annotations);
                if (converter == null) continue;
                return Optional.of(converter);
            }
            return Optional.empty();
        }).orElse(null);
    }
}

