/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.spring;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.tri.rest.RestConstants;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.RestExtensionAdapter;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.RestFilter;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Activate(onClass={"org.springframework.web.servlet.HandlerInterceptor"})
public final class HandlerInterceptorAdapter
implements RestExtensionAdapter<HandlerInterceptor> {
    @Override
    public boolean accept(Object extension) {
        return extension instanceof HandlerInterceptor;
    }

    @Override
    public RestFilter adapt(HandlerInterceptor extension) {
        return new HandlerInterceptorRestFilter(extension);
    }

    private static final class HandlerInterceptorRestFilter
    implements RestFilter,
    RestFilter.Listener {
        private final HandlerInterceptor interceptor;

        @Override
        public int getPriority() {
            return RestUtils.getPriority(this.interceptor);
        }

        @Override
        public String[] getPatterns() {
            return RestUtils.getPattens(this.interceptor);
        }

        public HandlerInterceptorRestFilter(HandlerInterceptor interceptor) {
            this.interceptor = interceptor;
        }

        @Override
        public void doFilter(HttpRequest request, HttpResponse response, RestFilter.FilterChain chain) throws Exception {
            Object handler = request.attribute(RestConstants.HANDLER_ATTRIBUTE);
            if (this.interceptor.preHandle((HttpServletRequest)request, (HttpServletResponse)response, handler)) {
                chain.doFilter(request, response);
            }
        }

        @Override
        public void onResponse(Result result, HttpRequest request, HttpResponse response) throws Exception {
            if (result.hasException()) {
                this.onError(result.getException(), request, response);
                return;
            }
            Object handler = request.attribute(RestConstants.HANDLER_ATTRIBUTE);
            ModelAndView mv = new ModelAndView();
            mv.addObject("result", (Object)result);
            this.interceptor.postHandle((HttpServletRequest)request, (HttpServletResponse)response, handler, mv);
        }

        @Override
        public void onError(Throwable t, HttpRequest request, HttpResponse response) throws Exception {
            Object handler = request.attribute(RestConstants.HANDLER_ATTRIBUTE);
            Exception ex = t instanceof Exception ? (Exception)t : new RpcException(t);
            this.interceptor.afterCompletion((HttpServletRequest)request, (HttpServletResponse)response, handler, ex);
        }

        public String toString() {
            Object[] patterns;
            StringBuilder sb = new StringBuilder("RestFilter{interceptor=");
            sb.append(this.interceptor);
            int priority = this.getPriority();
            if (priority != 0) {
                sb.append(", priority=").append(priority);
            }
            if ((patterns = this.getPatterns()) != null) {
                sb.append(", patterns=").append(Arrays.toString(patterns));
            }
            return sb.append('}').toString();
        }
    }
}

