/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.spring;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.ArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;

@Activate(onClass={"org.springframework.web.context.request.WebRequest"})
public class SpringMiscArgumentResolver
implements ArgumentResolver {
    private static final Set<Class<?>> SUPPORTED_TYPES = new HashSet();

    @Override
    public boolean accept(ParameterMeta parameter) {
        return SUPPORTED_TYPES.contains(parameter.getActualType());
    }

    @Override
    public Object resolve(ParameterMeta parameter, HttpRequest request, HttpResponse response) {
        Class<?> type = parameter.getActualType();
        if (type == WebRequest.class || type == NativeWebRequest.class) {
            return new ServletWebRequest((HttpServletRequest)request);
        }
        if (type == HttpEntity.class) {
            return new HttpEntity(CollectionUtils.toMultiValueMap(request.headers().asMap()));
        }
        if (type == HttpHeaders.class) {
            return new HttpHeaders(CollectionUtils.toMultiValueMap(request.headers().asMap()));
        }
        return null;
    }

    static {
        SUPPORTED_TYPES.add(WebRequest.class);
        SUPPORTED_TYPES.add(NativeWebRequest.class);
        SUPPORTED_TYPES.add(HttpEntity.class);
        SUPPORTED_TYPES.add(HttpHeaders.class);
    }
}

