/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.swagger;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.nested.OpenAPIConfig;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.HttpResult;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.ConfigFactory;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Helper;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.OpenAPIRequestHandler;
import org.apache.dubbo.rpc.protocol.tri.rest.support.swagger.WebjarHelper;
import org.apache.dubbo.rpc.protocol.tri.rest.util.PathUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;

@Activate
public class RedocRequestHandler
implements OpenAPIRequestHandler {
    private static final String DEFAULT_CDN = "https://cdn.redoc.ly/redoc/latest/bundles";
    private static final String INDEX_PATH = "/META-INF/resources/redoc/index.html";
    private final ConfigFactory configFactory;
    private OpenAPIConfig config;

    public RedocRequestHandler(FrameworkModel frameworkModel) {
        this.configFactory = frameworkModel.getOrRegisterBean(ConfigFactory.class);
    }

    private OpenAPIConfig getConfig() {
        if (this.config == null) {
            this.config = this.configFactory.getGlobalConfig();
        }
        return this.config;
    }

    @Override
    public String[] getPaths() {
        return new String[]{"/redoc/{*path}"};
    }

    @Override
    public HttpResult<?> handle(String path, HttpRequest request, HttpResponse response) {
        String resPath = RequestUtils.getPathVariable(request, "path");
        if (StringUtils.isEmpty(resPath)) {
            throw HttpResult.found(PathUtils.join(request.path(), "index.html")).toPayload();
        }
        String requestPath = StringUtils.substringBeforeLast(resPath, 46);
        if (requestPath.equals("index")) {
            return this.handleIndex(request.parameter("group", "default"));
        }
        if (WebjarHelper.ENABLED && requestPath.startsWith("assets/")) {
            return WebjarHelper.getInstance().handleAssets("redoc", resPath.substring(7));
        }
        throw new HttpStatusException(HttpStatus.NOT_FOUND.getCode());
    }

    private HttpResult<?> handleIndex(String group) {
        HashMap<String, String> variables = new HashMap<String, String>(4);
        OpenAPIConfig config = this.getConfig();
        String cdn = config.getSetting("redoc.cdn");
        if (cdn == null) {
            cdn = WebjarHelper.ENABLED && WebjarHelper.getInstance().hasWebjar("redoc") ? "./assets" : DEFAULT_CDN;
        }
        variables.put("redoc.cdn", cdn);
        variables.put("group", group);
        try {
            String content = StreamUtils.toString(this.getClass().getResourceAsStream(INDEX_PATH));
            return HttpResult.of(Helper.render(content, variables::get).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new HttpStatusException(HttpStatus.INTERNAL_SERVER_ERROR.getCode(), (Throwable)e);
        }
    }
}

