/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.swagger;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.BeanMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.MethodMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ServiceMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Helper;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.OpenAPIDefinitionResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.OpenAPISchemaPredicate;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.OpenAPISchemaResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.ExternalDocs;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.License;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.OpenAPI;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.PathItem;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Schema;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Tag;

@Activate(order=50, onClass={"io.swagger.v3.oas.annotations.OpenAPIDefinition"})
public final class SwaggerOpenAPIDefinitionResolver
implements OpenAPIDefinitionResolver,
OpenAPISchemaResolver,
OpenAPISchemaPredicate {
    @Override
    public OpenAPI resolve(OpenAPI openAPI, ServiceMeta serviceMeta, OpenAPIDefinitionResolver.OpenAPIChain chain) {
        AnnotationMeta<OpenAPIDefinition> annoMeta = serviceMeta.findAnnotation(OpenAPIDefinition.class);
        if (annoMeta == null) {
            return chain.resolve(openAPI, serviceMeta);
        }
        if (serviceMeta.isHierarchyAnnotated(Hidden.class)) {
            return null;
        }
        OpenAPIDefinition anno = annoMeta.getAnnotation();
        org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Info info = openAPI.getInfo();
        if (info == null) {
            info = new org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Info();
            openAPI.setInfo(info);
        }
        Info infoAnn = anno.info();
        info.setTitle(Helper.trim(infoAnn.title())).setDescription(Helper.trim(infoAnn.description())).setVersion(Helper.trim(infoAnn.version())).setExtensions(SwaggerOpenAPIDefinitionResolver.toProperties(infoAnn.extensions()));
        org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Contact contact = new org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Contact();
        info.setContact(contact);
        Contact contactAnn = infoAnn.contact();
        contact.setName(Helper.trim(contactAnn.name())).setEmail(Helper.trim(contactAnn.email())).setUrl(Helper.trim(contactAnn.url())).setExtensions(SwaggerOpenAPIDefinitionResolver.toProperties(contactAnn.extensions()));
        License license = new License();
        info.setLicense(license);
        io.swagger.v3.oas.annotations.info.License licenseAnn = infoAnn.license();
        license.setName(Helper.trim(licenseAnn.name())).setUrl(Helper.trim(licenseAnn.url())).setExtensions(SwaggerOpenAPIDefinitionResolver.toProperties(licenseAnn.extensions()));
        for (io.swagger.v3.oas.annotations.tags.Tag tagAnn : anno.tags()) {
            openAPI.addTag((Tag)new Tag().setName(Helper.trim(tagAnn.name())).setDescription(Helper.trim(tagAnn.description())).setExternalDocs(SwaggerOpenAPIDefinitionResolver.toExternalDocs(tagAnn.externalDocs())).setExtensions(SwaggerOpenAPIDefinitionResolver.toProperties(tagAnn.extensions())));
        }
        openAPI.setExternalDocs(SwaggerOpenAPIDefinitionResolver.toExternalDocs(anno.externalDocs()));
        Map<String, String> properties = SwaggerOpenAPIDefinitionResolver.toProperties(anno.extensions());
        if (properties != null) {
            String group = properties.remove("x-api-group");
            if (group != null) {
                openAPI.setGroup(group);
            }
            openAPI.setExtensions(properties);
        }
        return chain.resolve(openAPI, serviceMeta);
    }

    private static Map<String, String> toProperties(Extension[] extensions) {
        int len = extensions.length;
        if (len == 0) {
            return null;
        }
        Map<String, String> properties = CollectionUtils.newLinkedHashMap(extensions.length);
        for (Extension extension : extensions) {
            for (ExtensionProperty property : extension.properties()) {
                properties.put(property.name(), property.value());
            }
        }
        return properties;
    }

    private static ExternalDocs toExternalDocs(ExternalDocumentation anno) {
        return (ExternalDocs)new ExternalDocs().setDescription(Helper.trim(anno.description())).setUrl(Helper.trim(anno.url())).setExtensions(SwaggerOpenAPIDefinitionResolver.toProperties(anno.extensions()));
    }

    @Override
    public Collection<HttpMethods> resolve(PathItem pathItem, MethodMeta methodMeta, OpenAPIDefinitionResolver.OperationContext context) {
        AnnotationMeta<Operation> annoMeta = methodMeta.findAnnotation(Operation.class);
        if (annoMeta == null) {
            return null;
        }
        String method = Helper.trim(annoMeta.getAnnotation().method());
        if (method == null) {
            return null;
        }
        return Collections.singletonList(HttpMethods.of(method.toUpperCase()));
    }

    @Override
    public org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Operation resolve(org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Operation operation, MethodMeta methodMeta, OpenAPIDefinitionResolver.OperationContext ctx, OpenAPIDefinitionResolver.OperationChain chain) {
        AnnotationMeta<Operation> annoMeta = methodMeta.findAnnotation(Operation.class);
        if (annoMeta == null) {
            return chain.resolve(operation, methodMeta, ctx);
        }
        Operation anno = annoMeta.getAnnotation();
        if (anno.hidden() || methodMeta.isHierarchyAnnotated(Hidden.class)) {
            return null;
        }
        String method = Helper.trim(anno.method());
        if (method != null) {
            operation.setHttpMethod(HttpMethods.of(method.toUpperCase()));
        }
        for (String tag : anno.tags()) {
            operation.addTag(tag);
        }
        Map<String, String> properties = SwaggerOpenAPIDefinitionResolver.toProperties(anno.extensions());
        if (properties != null) {
            String version;
            String group = properties.remove("x-api-group");
            if (group != null) {
                operation.setGroup(group);
            }
            if ((version = properties.remove("x-api-version")) != null) {
                operation.setVersion(version);
            }
            operation.setExtensions(properties);
        }
        operation.setSummary(Helper.trim(anno.summary())).setDescription(Helper.trim(anno.description())).setExternalDocs(SwaggerOpenAPIDefinitionResolver.toExternalDocs(anno.externalDocs())).setOperationId(Helper.trim(anno.operationId())).setDeprecated(anno.deprecated() ? Boolean.TRUE : null);
        return chain.resolve(operation, methodMeta, ctx);
    }

    @Override
    public org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Schema resolve(ParameterMeta parameter, OpenAPISchemaResolver.SchemaContext context, OpenAPISchemaResolver.SchemaChain chain) {
        AnnotationMeta<Schema> annoMeta = parameter.getAnnotation(Schema.class);
        if (annoMeta == null) {
            return chain.resolve(parameter, context);
        }
        Schema anno = annoMeta.getAnnotation();
        if (anno.hidden() || parameter.isHierarchyAnnotated(Hidden.class)) {
            return null;
        }
        org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Schema schema = chain.resolve(parameter, context);
        if (schema == null) {
            return null;
        }
        Map<String, String> properties = SwaggerOpenAPIDefinitionResolver.toProperties(anno.extensions());
        if (properties != null) {
            String version;
            String group = properties.remove("x-api-group");
            if (group != null) {
                schema.setGroup(group);
            }
            if ((version = properties.remove("x-api-version")) != null) {
                schema.setVersion(version);
            }
            schema.setExtensions(properties);
        }
        Helper.setValue(() -> ((Schema)anno).type(), v -> schema.setType(Schema.Type.valueOf(v)));
        Helper.setValue(() -> ((Schema)anno).format(), schema::setFormat);
        Helper.setValue(() -> ((Schema)anno).name(), schema::setName);
        Helper.setValue(() -> ((Schema)anno).title(), schema::setTitle);
        Helper.setValue(() -> ((Schema)anno).description(), schema::setDescription);
        Helper.setValue(() -> ((Schema)anno).defaultValue(), schema::setDefaultValue);
        Helper.setValue(() -> ((Schema)anno).pattern(), schema::setPattern);
        Helper.setValue(() -> ((Schema)anno).example(), schema::setExample);
        String[] enumItems = Helper.trim(anno.allowableValues());
        if (enumItems != null) {
            schema.setEnumeration(Arrays.asList(enumItems));
        }
        schema.setRequired(anno.requiredMode() == Schema.RequiredMode.REQUIRED ? Boolean.TRUE : null);
        schema.setReadOnly(anno.accessMode() == Schema.AccessMode.READ_ONLY ? Boolean.TRUE : null);
        schema.setWriteOnly(anno.accessMode() == Schema.AccessMode.WRITE_ONLY ? Boolean.TRUE : null);
        schema.setNullable(anno.nullable() ? Boolean.TRUE : null);
        schema.setDeprecated(anno.deprecated() ? Boolean.TRUE : null);
        return chain.resolve(parameter, context);
    }

    @Override
    public Boolean acceptProperty(BeanMeta bean, BeanMeta.PropertyMeta property) {
        AnnotationMeta<Schema> meta = bean.getAnnotation(Schema.class);
        if (meta == null) {
            return null;
        }
        Schema schema = meta.getAnnotation();
        return schema.hidden() || bean.isHierarchyAnnotated(Hidden.class) ? Boolean.valueOf(false) : null;
    }
}

