/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class MethodWalker {
    private final Set<Class<?>> classes = new LinkedHashSet();
    private final Map<Key, List<Method>> methodsMap = new HashMap<Key, List<Method>>();

    public void walk(Class<?> clazz, BiConsumer<Set<Class<?>>, Consumer<Consumer<List<Method>>>> visitor) {
        if (clazz.getName().contains("$$")) {
            clazz = clazz.getSuperclass();
        }
        this.walkHierarchy(clazz);
        visitor.accept(this.classes, consumer -> {
            for (Map.Entry<Key, List<Method>> entry : this.methodsMap.entrySet()) {
                consumer.accept(entry.getValue());
            }
        });
    }

    private void walkHierarchy(Class<?> clazz) {
        if (this.classes.isEmpty() || clazz.getDeclaredAnnotations().length > 0) {
            this.classes.add(clazz);
        }
        for (Method method : clazz.getDeclaredMethods()) {
            int modifiers = method.getModifiers();
            if ((modifiers & 9) != 1) continue;
            this.methodsMap.computeIfAbsent(Key.of(method), k -> new ArrayList()).add(method);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            this.walkHierarchy(superClass);
        }
        for (Class<?> itf : clazz.getInterfaces()) {
            this.walkHierarchy(itf);
        }
    }

    private static final class Key {
        private final String name;
        private final Class<?>[] parameterTypes;

        private Key(String name, Class<?>[] parameterTypes) {
            this.name = name;
            this.parameterTypes = parameterTypes;
        }

        private static Key of(Method method) {
            return new Key(method.getName(), method.getParameterTypes());
        }

        public boolean equals(Object obj) {
            Key key = (Key)obj;
            return this.name.equals(key.name) && Arrays.equals(this.parameterTypes, key.parameterTypes);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            for (Class<?> type : this.parameterTypes) {
                result = 31 * result + type.hashCode();
            }
            return result;
        }

        public String toString() {
            return this.name + Arrays.toString(this.parameterTypes);
        }
    }
}

