/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.stream;

import io.netty.handler.codec.DateFormatter;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.common.utils.LRU2Cache;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;

public final class StreamUtils {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(StreamUtils.class);
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder().withoutPadding();
    private static final int MAX_LRU_HEADER_MAP_SIZE = 10000;
    private static final Map<String, String> lruHeaderMap = new LRU2Cache<String, String>(10000);

    private StreamUtils() {
    }

    public static String encodeBase64ASCII(byte[] in) {
        return new String(StreamUtils.encodeBase64(in), StandardCharsets.US_ASCII);
    }

    public static byte[] encodeBase64(byte[] in) {
        return BASE64_ENCODER.encode(in);
    }

    public static byte[] decodeASCIIByte(String value) {
        return BASE64_DECODER.decode(value.getBytes(StandardCharsets.US_ASCII));
    }

    public static void putHeaders(DefaultHttp2Headers headers, Map<String, Object> attachments, boolean needConvertHeaderKey) {
        StreamUtils.putHeaders(attachments, needConvertHeaderKey, (arg_0, arg_1) -> ((DefaultHttp2Headers)headers).set(arg_0, arg_1));
    }

    public static void putHeaders(HttpHeaders headers, Map<String, Object> attachments, boolean needConvertHeaderKey) {
        StreamUtils.putHeaders(attachments, needConvertHeaderKey, headers::set);
    }

    private static void putHeaders(Map<String, Object> attachments, boolean needConvertHeaderKey, BiConsumer<CharSequence, String> consumer) {
        if (CollectionUtils.isEmptyMap(attachments)) {
            return;
        }
        HashMap<String, String> needConvertKeys = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : attachments.entrySet()) {
            String key;
            String lowerCaseKey;
            Object value = entry.getValue();
            if (value == null || TripleHeaderEnum.containsExcludeAttachments(lowerCaseKey = lruHeaderMap.computeIfAbsent(key = entry.getKey(), k -> k.toLowerCase(Locale.ROOT)))) continue;
            if (needConvertHeaderKey && !lowerCaseKey.equals(key)) {
                needConvertKeys.put(lowerCaseKey, key);
            }
            StreamUtils.putHeader(consumer, lowerCaseKey, value);
        }
        if (needConvertKeys.isEmpty()) {
            return;
        }
        consumer.accept(TripleHeaderEnum.TRI_HEADER_CONVERT.getKey(), TriRpcStatus.encodeMessage(JsonUtils.toJson(needConvertKeys)));
    }

    private static void putHeader(BiConsumer<CharSequence, String> consumer, String key, Object value) {
        try {
            if (value instanceof CharSequence || value instanceof Number || value instanceof Boolean) {
                String str = value.toString();
                consumer.accept(key, str);
            } else if (value instanceof Date) {
                consumer.accept(key, DateFormatter.format((Date)((Date)value)));
            } else if (value instanceof byte[]) {
                String str = StreamUtils.encodeBase64ASCII((byte[])value);
                consumer.accept(key + "-bin", str);
            } else {
                LOGGER.warn("4-1", "", "", "Unsupported attachment k: " + key + " class: " + value.getClass().getName());
            }
        }
        catch (Throwable t) {
            LOGGER.warn("4-1", "", "", "Meet exception when convert single attachment key:" + key + " value=" + value, t);
        }
    }

    public static Map<String, Object> toAttachments(Map<String, Object> map) {
        if (CollectionUtils.isEmptyMap(map)) {
            return Collections.emptyMap();
        }
        Map<String, Object> res = CollectionUtils.newHashMap(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            if (TripleHeaderEnum.containsExcludeAttachments(key)) continue;
            res.put(key, entry.getValue());
        }
        return res;
    }

    public static Map<String, Object> toAttachments(HttpHeaders headers) {
        if (headers == null) {
            return Collections.emptyMap();
        }
        Map<String, Object> attachments = CollectionUtils.newHashMap(headers.size());
        for (Map.Entry<CharSequence, String> entry : headers) {
            String key = entry.getKey().toString();
            String value = entry.getValue();
            int len = key.length() - "-bin".length();
            if (len > 0 && "-bin".equals(key.substring(len))) {
                try {
                    StreamUtils.putAttachment(attachments, key.substring(0, len), value == null ? null : StreamUtils.decodeASCIIByte(value));
                }
                catch (Exception e) {
                    LOGGER.error("4-9", "", "", "Failed to parse response attachment key=" + key, e);
                }
                continue;
            }
            StreamUtils.putAttachment(attachments, key, value);
        }
        String converted = headers.getFirst(TripleHeaderEnum.TRI_HEADER_CONVERT.getKey());
        if (converted == null) {
            return attachments;
        }
        String json = TriRpcStatus.decodeMessage(converted);
        Map map = (Map)JsonUtils.toJavaObject(json, Map.class);
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = attachments.remove(key);
            if (value == null) continue;
            StreamUtils.putAttachment(attachments, (String)entry.getValue(), value);
        }
        return attachments;
    }

    private static void putAttachment(Map<String, Object> attachments, String key, Object value) {
        if (TripleHeaderEnum.containsExcludeAttachments(key)) {
            return;
        }
        attachments.put(key, value);
    }
}

