/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.stream;

import io.netty.channel.Channel;
import io.netty.handler.codec.http2.Http2StreamChannel;
import java.util.concurrent.CompletableFuture;
import org.apache.dubbo.common.utils.Assert;

public class TripleStreamChannelFuture
extends CompletableFuture<Channel> {
    private final Channel parentChannel;
    private Throwable cause;

    public TripleStreamChannelFuture(Channel parentChannel) {
        Assert.notNull((Object)parentChannel, "parentChannel cannot be null.");
        this.parentChannel = parentChannel;
    }

    public TripleStreamChannelFuture(Http2StreamChannel channel) {
        this.complete(channel);
        this.parentChannel = channel.parent();
    }

    public Channel getParentChannel() {
        return this.parentChannel;
    }

    @Override
    public boolean completeExceptionally(Throwable cause) {
        boolean result = super.completeExceptionally(cause);
        if (result) {
            this.cause = cause;
        }
        return result;
    }

    public Throwable cause() {
        return this.cause;
    }

    public boolean isSuccess() {
        return this.isDone() && this.cause() == null;
    }

    public Channel getNow() {
        return this.getNow(null);
    }
}

