/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.websocket;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.websocket.CloseReason;
import javax.websocket.Session;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.nested.TripleConfig;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.LimitedByteArrayOutputStream;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2Header;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessage;
import org.apache.dubbo.remoting.http12.h2.Http2OutputMessageFrame;
import org.apache.dubbo.remoting.websocket.WebSocketHeaderNames;

public class WebSocketStreamChannel
implements H2StreamChannel {
    private final Session session;
    private final TripleConfig tripleConfig;
    private final InetSocketAddress remoteAddress;
    private final InetSocketAddress localAddress;

    public WebSocketStreamChannel(Session session, TripleConfig tripleConfig) {
        this.session = session;
        this.tripleConfig = tripleConfig;
        Map requestParameterMap = session.getRequestParameterMap();
        List remoteAddressData = (List)requestParameterMap.get("tri.websocket.remote.address");
        this.remoteAddress = InetSocketAddress.createUnresolved((String)remoteAddressData.get(0), Integer.parseInt((String)remoteAddressData.get(1)));
        this.localAddress = InetSocketAddress.createUnresolved(session.getRequestURI().getHost(), session.getRequestURI().getPort());
    }

    @Override
    public CompletableFuture<Void> writeResetFrame(long errorCode) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        try {
            this.session.close();
            completableFuture.complete(null);
        }
        catch (IOException e) {
            completableFuture.completeExceptionally(e);
        }
        return completableFuture;
    }

    @Override
    public Http2OutputMessage newOutputMessage(boolean endStream) {
        return new Http2OutputMessageFrame(new LimitedByteArrayOutputStream(256, this.tripleConfig.getMaxResponseBodySizeOrDefault()), endStream);
    }

    @Override
    public CompletableFuture<Void> writeHeader(HttpMetadata httpMetadata) {
        Http2Header http2Header = (Http2Header)httpMetadata;
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        if (http2Header.isEndStream()) {
            try {
                this.session.close(this.encodeCloseReason(http2Header));
                completableFuture.complete(null);
            }
            catch (IOException e) {
                completableFuture.completeExceptionally(e);
            }
        }
        return completableFuture;
    }

    @Override
    public CompletableFuture<Void> writeMessage(HttpOutputMessage httpOutputMessage) {
        ByteArrayOutputStream body = (ByteArrayOutputStream)httpOutputMessage.getBody();
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        try {
            this.session.getBasicRemote().sendBinary(ByteBuffer.wrap(body.toByteArray()));
            completableFuture.complete(null);
        }
        catch (IOException e) {
            completableFuture.completeExceptionally(e);
        }
        return completableFuture;
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public SocketAddress localAddress() {
        return this.localAddress;
    }

    @Override
    public void flush() {
    }

    private CloseReason encodeCloseReason(Http2Header http2Header) {
        List<String> messageHeaders;
        HttpHeaders headers = http2Header.headers();
        List<String> statusHeaders = headers.remove(HttpHeaderNames.STATUS.getName());
        CloseReason closeReason = CollectionUtils.isNotEmpty(statusHeaders) && !HttpStatus.OK.getStatusString().equals(statusHeaders.get(0)) ? new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, CollectionUtils.isNotEmpty(messageHeaders = headers.remove(WebSocketHeaderNames.WEBSOCKET_MESSAGE.getName())) ? messageHeaders.get(0) : "Internal server error") : new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Bye");
        return closeReason;
    }
}

