/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.tracing;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.common.lang.Nullable;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.support.RpcUtils;
import org.apache.dubbo.tracing.DubboObservationDocumentation;

class AbstractDefaultDubboObservationConvention {
    AbstractDefaultDubboObservationConvention() {
    }

    KeyValues getLowCardinalityKeyValues(Invocation invocation) {
        KeyValues keyValues = KeyValues.of((KeyValue[])new KeyValue[]{DubboObservationDocumentation.LowCardinalityKeyNames.RPC_SYSTEM.withValue("apache_dubbo")});
        String serviceName = StringUtils.hasText(invocation.getServiceName()) ? invocation.getServiceName() : this.readServiceName(invocation.getTargetServiceUniqueName());
        keyValues = this.appendNonNull(keyValues, DubboObservationDocumentation.LowCardinalityKeyNames.RPC_SERVICE, serviceName);
        return this.appendNonNull(keyValues, DubboObservationDocumentation.LowCardinalityKeyNames.RPC_METHOD, RpcUtils.getMethodName(invocation));
    }

    protected KeyValues appendNonNull(KeyValues keyValues, KeyName keyName, @Nullable String value) {
        if (value != null) {
            return keyValues.and(new KeyValue[]{keyName.withValue(value)});
        }
        return keyValues;
    }

    String getContextualName(Invocation invocation) {
        String serviceName = StringUtils.hasText(invocation.getServiceName()) ? invocation.getServiceName() : this.readServiceName(invocation.getTargetServiceUniqueName());
        String methodName = RpcUtils.getMethodName(invocation);
        String method = StringUtils.hasText(methodName) ? methodName : "";
        return serviceName + "/" + method;
    }

    private String readServiceName(String targetServiceUniqueName) {
        String[] splitByHyphen = targetServiceUniqueName.split("/");
        String withVersion = splitByHyphen.length == 1 ? targetServiceUniqueName : splitByHyphen[1];
        String[] splitByVersion = withVersion.split(":");
        if (splitByVersion.length == 1) {
            return withVersion;
        }
        return splitByVersion[0];
    }
}

