/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.AboutPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.AppPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.CapacitySchedulerPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.DefaultSchedulerPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.FairSchedulerPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.NodesPage;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.Controller;

public class RmController
extends Controller {
    @Inject
    RmController(Controller.RequestContext ctx) {
        super(ctx);
    }

    public void index() {
        this.setTitle("Applications");
    }

    public void about() {
        this.setTitle("About the Cluster");
        this.render(AboutPage.class);
    }

    public void app() {
        this.render(AppPage.class);
    }

    public void nodes() {
        this.render(NodesPage.class);
    }

    public void scheduler() {
        this.set("app.state", StringHelper.cjoin((Object[])new Object[]{YarnApplicationState.NEW.toString(), YarnApplicationState.NEW_SAVING.toString(), YarnApplicationState.SUBMITTED.toString(), YarnApplicationState.ACCEPTED.toString(), YarnApplicationState.RUNNING.toString()}));
        ResourceManager rm = (ResourceManager)this.getInstance(ResourceManager.class);
        ResourceScheduler rs = rm.getResourceScheduler();
        if (rs == null || rs instanceof CapacityScheduler) {
            this.setTitle("Capacity Scheduler");
            this.render(CapacitySchedulerPage.class);
            return;
        }
        if (rs instanceof FairScheduler) {
            this.setTitle("Fair Scheduler");
            this.render(FairSchedulerPage.class);
            return;
        }
        this.setTitle("Default Scheduler");
        this.render(DefaultSchedulerPage.class);
    }

    public void queue() {
        this.setTitle(StringHelper.join((Object[])new Object[]{"Queue ", this.get("queue.name", "unknown")}));
    }

    public void submit() {
        this.setTitle("Application Submission Not Allowed");
    }
}

