/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.util.Random;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermDocs;

public class DeleteByPercentTask
extends PerfTask {
    double percent;
    int numDeleted = 0;
    final Random random;

    public DeleteByPercentTask(PerfRunData runData) {
        super(runData);
        this.random = new Random(runData.getConfig().get("delete.percent.rand.seed", 1717));
    }

    public void setup() throws Exception {
        super.setup();
    }

    public void setParams(String params) {
        super.setParams(params);
        this.percent = Double.parseDouble(params) / 100.0;
    }

    public boolean supportsParams() {
        return true;
    }

    public int doLogic() throws Exception {
        IndexReader r = this.getRunData().getIndexReader();
        int maxDoc = r.maxDoc();
        int numDeleted = 0;
        int numToDelete = (int)((double)maxDoc * this.percent) - r.numDeletedDocs();
        if (numToDelete < 0) {
            r.undeleteAll();
            numToDelete = (int)((double)maxDoc * this.percent);
        }
        while (numDeleted < numToDelete) {
            double delRate = (double)(numToDelete - numDeleted) / (double)r.numDocs();
            TermDocs termDocs = r.termDocs(null);
            while (termDocs.next() && numDeleted < numToDelete) {
                if (!(this.random.nextDouble() <= delRate)) continue;
                r.deleteDocument(termDocs.doc());
                ++numDeleted;
            }
            termDocs.close();
        }
        System.out.println("--> processed (delete) " + numDeleted + " docs");
        r.decRef();
        return numDeleted;
    }
}

