/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.StringHelper;

public abstract class PointValues {
    public static final int MAX_NUM_BYTES = 16;
    public static final int MAX_DIMENSIONS = 8;

    public static long size(IndexReader reader, String field) throws IOException {
        long size = 0L;
        for (LeafReaderContext ctx : reader.leaves()) {
            PointValues values = ctx.reader().getPointValues();
            if (values == null) continue;
            size += values.size(field);
        }
        return size;
    }

    public static int getDocCount(IndexReader reader, String field) throws IOException {
        int count = 0;
        for (LeafReaderContext ctx : reader.leaves()) {
            PointValues values = ctx.reader().getPointValues();
            if (values == null) continue;
            count += values.getDocCount(field);
        }
        return count;
    }

    public static byte[] getMinPackedValue(IndexReader reader, String field) throws IOException {
        byte[] minValue = null;
        for (LeafReaderContext ctx : reader.leaves()) {
            byte[] leafMinValue;
            PointValues values = ctx.reader().getPointValues();
            if (values == null || (leafMinValue = values.getMinPackedValue(field)) == null) continue;
            if (minValue == null) {
                minValue = (byte[])leafMinValue.clone();
                continue;
            }
            int numDimensions = values.getNumDimensions(field);
            int numBytesPerDimension = values.getBytesPerDimension(field);
            for (int i = 0; i < numDimensions; ++i) {
                int offset = i * numBytesPerDimension;
                if (StringHelper.compare(numBytesPerDimension, leafMinValue, offset, minValue, offset) >= 0) continue;
                System.arraycopy(leafMinValue, offset, minValue, offset, numBytesPerDimension);
            }
        }
        return minValue;
    }

    public static byte[] getMaxPackedValue(IndexReader reader, String field) throws IOException {
        byte[] maxValue = null;
        for (LeafReaderContext ctx : reader.leaves()) {
            byte[] leafMaxValue;
            PointValues values = ctx.reader().getPointValues();
            if (values == null || (leafMaxValue = values.getMaxPackedValue(field)) == null) continue;
            if (maxValue == null) {
                maxValue = (byte[])leafMaxValue.clone();
                continue;
            }
            int numDimensions = values.getNumDimensions(field);
            int numBytesPerDimension = values.getBytesPerDimension(field);
            for (int i = 0; i < numDimensions; ++i) {
                int offset = i * numBytesPerDimension;
                if (StringHelper.compare(numBytesPerDimension, leafMaxValue, offset, maxValue, offset) <= 0) continue;
                System.arraycopy(leafMaxValue, offset, maxValue, offset, numBytesPerDimension);
            }
        }
        return maxValue;
    }

    protected PointValues() {
    }

    public abstract void intersect(String var1, IntersectVisitor var2) throws IOException;

    public abstract byte[] getMinPackedValue(String var1) throws IOException;

    public abstract byte[] getMaxPackedValue(String var1) throws IOException;

    public abstract int getNumDimensions(String var1) throws IOException;

    public abstract int getBytesPerDimension(String var1) throws IOException;

    public abstract long size(String var1);

    public abstract int getDocCount(String var1);

    public static interface IntersectVisitor {
        public void visit(int var1) throws IOException;

        public void visit(int var1, byte[] var2) throws IOException;

        public Relation compare(byte[] var1, byte[] var2);

        default public void grow(int count) {
        }
    }

    public static enum Relation {
        CELL_INSIDE_QUERY,
        CELL_OUTSIDE_QUERY,
        CELL_CROSSES_QUERY;

    }
}

