/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.bkd;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.bkd.PointReader;
import org.apache.lucene.util.bkd.PointValue;

public final class HeapPointReader
implements PointReader {
    private int curRead;
    final byte[] block;
    final int packedBytesLength;
    final int[] docIDs;
    final int end;
    private final HeapPointValue pointValue;

    public HeapPointReader(byte[] block, int packedBytesLength, int[] docIDs, int start, int end) {
        this.block = block;
        this.docIDs = docIDs;
        this.curRead = start - 1;
        this.end = end;
        this.packedBytesLength = packedBytesLength;
        this.pointValue = start < end ? new HeapPointValue(block, packedBytesLength) : null;
    }

    @Override
    public boolean next() {
        ++this.curRead;
        return this.curRead < this.end;
    }

    @Override
    public PointValue pointValue() {
        this.pointValue.setValue(this.curRead * this.packedBytesLength, this.docIDs[this.curRead]);
        return this.pointValue;
    }

    @Override
    public void close() {
    }

    static class HeapPointValue
    implements PointValue {
        BytesRef packedValue;
        BytesRef docIDBytes;
        int docID;

        public HeapPointValue(byte[] value, int packedLength) {
            this.packedValue = new BytesRef(value, 0, packedLength);
            this.docIDBytes = new BytesRef(new byte[4]);
        }

        public void setValue(int offset, int docID) {
            this.docID = docID;
            this.packedValue.offset = offset;
        }

        @Override
        public BytesRef packedValue() {
            return this.packedValue;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public BytesRef docIDBytes() {
            this.docIDBytes.bytes[0] = (byte)(this.docID >> 24);
            this.docIDBytes.bytes[1] = (byte)(this.docID >> 16);
            this.docIDBytes.bytes[2] = (byte)(this.docID >> 8);
            this.docIDBytes.bytes[3] = (byte)(this.docID >> 0);
            return this.docIDBytes;
        }
    }
}

