/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;

abstract class SortedSetDocValuesRangeQuery
extends Query {
    private final String field;
    private final BytesRef lowerValue;
    private final BytesRef upperValue;
    private final boolean lowerInclusive;
    private final boolean upperInclusive;

    SortedSetDocValuesRangeQuery(String field, BytesRef lowerValue, BytesRef upperValue, boolean lowerInclusive, boolean upperInclusive) {
        this.field = Objects.requireNonNull(field);
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
        this.lowerInclusive = lowerInclusive && lowerValue != null;
        this.upperInclusive = upperInclusive && upperValue != null;
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        SortedSetDocValuesRangeQuery that = (SortedSetDocValuesRangeQuery)obj;
        return Objects.equals(this.field, that.field) && Objects.equals(this.lowerValue, that.lowerValue) && Objects.equals(this.upperValue, that.upperValue) && this.lowerInclusive == that.lowerInclusive && this.upperInclusive == that.upperInclusive;
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.field.hashCode();
        h = 31 * h + Objects.hashCode(this.lowerValue);
        h = 31 * h + Objects.hashCode(this.upperValue);
        h = 31 * h + Boolean.hashCode(this.lowerInclusive);
        h = 31 * h + Boolean.hashCode(this.upperInclusive);
        return h;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.field.equals(field)) {
            b.append(this.field).append(":");
        }
        return b.append(this.lowerInclusive ? "[" : "{").append(this.lowerValue == null ? "*" : this.lowerValue).append(" TO ").append(this.upperValue == null ? "*" : this.upperValue).append(this.upperInclusive ? "]" : "}").toString();
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.lowerValue == null && this.upperValue == null) {
            return new FieldExistsQuery(this.field);
        }
        return super.rewrite(reader);
    }

    abstract SortedSetDocValues getValues(LeafReader var1, String var2) throws IOException;

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                long ord;
                long maxOrd;
                long ord2;
                final SortedSetDocValues values = SortedSetDocValuesRangeQuery.this.getValues(context.reader(), SortedSetDocValuesRangeQuery.this.field);
                if (values == null) {
                    return null;
                }
                final long minOrd = SortedSetDocValuesRangeQuery.this.lowerValue == null ? 0L : ((ord2 = values.lookupTerm(SortedSetDocValuesRangeQuery.this.lowerValue)) < 0L ? -1L - ord2 : (SortedSetDocValuesRangeQuery.this.lowerInclusive ? ord2 : ord2 + 1L));
                if (minOrd > (maxOrd = SortedSetDocValuesRangeQuery.this.upperValue == null ? values.getValueCount() - 1L : ((ord = values.lookupTerm(SortedSetDocValuesRangeQuery.this.upperValue)) < 0L ? -2L - ord : (SortedSetDocValuesRangeQuery.this.upperInclusive ? ord : ord - 1L)))) {
                    return null;
                }
                final SortedDocValues singleton = DocValues.unwrapSingleton(values);
                TwoPhaseIterator iterator = singleton != null ? new TwoPhaseIterator(singleton){

                    @Override
                    public boolean matches() throws IOException {
                        long ord = singleton.ordValue();
                        return ord >= minOrd && ord <= maxOrd;
                    }

                    @Override
                    public float matchCost() {
                        return 2.0f;
                    }
                } : new TwoPhaseIterator(values){

                    @Override
                    public boolean matches() throws IOException {
                        long ord = values.nextOrd();
                        while (ord != -1L) {
                            if (ord >= minOrd) {
                                return ord <= maxOrd;
                            }
                            ord = values.nextOrd();
                        }
                        return false;
                    }

                    @Override
                    public float matchCost() {
                        return 2.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, iterator);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, SortedSetDocValuesRangeQuery.this.field);
            }
        };
    }
}

