/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dal.show;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.rule.TableRule;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.underlying.common.rule.BaseRule;
import org.apache.shardingsphere.underlying.executor.QueryResult;
import org.apache.shardingsphere.underlying.merge.result.impl.memory.MemoryMergedResult;
import org.apache.shardingsphere.underlying.merge.result.impl.memory.MemoryQueryResultRow;

public class LogicTablesMergedResult
extends MemoryMergedResult<ShardingRule> {
    public LogicTablesMergedResult(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, SchemaMetaData schemaMetaData, List<QueryResult> queryResults) throws SQLException {
        super((BaseRule)shardingRule, schemaMetaData, sqlStatementContext, queryResults);
    }

    protected final List<MemoryQueryResultRow> init(ShardingRule shardingRule, SchemaMetaData schemaMetaData, SQLStatementContext sqlStatementContext, List<QueryResult> queryResults) throws SQLException {
        LinkedList<MemoryQueryResultRow> result = new LinkedList<MemoryQueryResultRow>();
        HashSet<String> tableNames = new HashSet<String>();
        for (QueryResult each : queryResults) {
            while (each.next()) {
                MemoryQueryResultRow memoryResultSetRow = new MemoryQueryResultRow(each);
                String actualTableName = memoryResultSetRow.getCell(1).toString();
                Optional tableRule = shardingRule.findTableRuleByActualTable(actualTableName);
                if (!tableRule.isPresent()) {
                    if (!shardingRule.getTableRules().isEmpty() && (!schemaMetaData.containsTable(actualTableName) || !tableNames.add(actualTableName))) continue;
                    result.add(memoryResultSetRow);
                    continue;
                }
                if (!tableNames.add(((TableRule)tableRule.get()).getLogicTable())) continue;
                memoryResultSetRow.setCell(1, (Object)((TableRule)tableRule.get()).getLogicTable());
                this.setCellValue(memoryResultSetRow, ((TableRule)tableRule.get()).getLogicTable(), actualTableName);
                result.add(memoryResultSetRow);
            }
        }
        return result;
    }

    protected void setCellValue(MemoryQueryResultRow memoryResultSetRow, String logicTableName, String actualTableName) {
    }
}

