/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dql.groupby.aggregation;

import lombok.Generated;
import org.apache.shardingsphere.sharding.merge.dql.groupby.aggregation.AccumulationAggregationUnit;
import org.apache.shardingsphere.sharding.merge.dql.groupby.aggregation.AggregationUnit;
import org.apache.shardingsphere.sharding.merge.dql.groupby.aggregation.AverageAggregationUnit;
import org.apache.shardingsphere.sharding.merge.dql.groupby.aggregation.ComparableAggregationUnit;
import org.apache.shardingsphere.sharding.merge.dql.groupby.aggregation.DistinctAverageAggregationUnit;
import org.apache.shardingsphere.sharding.merge.dql.groupby.aggregation.DistinctCountAggregationUnit;
import org.apache.shardingsphere.sharding.merge.dql.groupby.aggregation.DistinctSumAggregationUnit;
import org.apache.shardingsphere.sql.parser.sql.constant.AggregationType;

public final class AggregationUnitFactory {
    public static AggregationUnit create(AggregationType type, boolean isDistinct) {
        switch (type) {
            case MAX: {
                return new ComparableAggregationUnit(false);
            }
            case MIN: {
                return new ComparableAggregationUnit(true);
            }
            case SUM: {
                return isDistinct ? new DistinctSumAggregationUnit() : new AccumulationAggregationUnit();
            }
            case COUNT: {
                return isDistinct ? new DistinctCountAggregationUnit() : new AccumulationAggregationUnit();
            }
            case AVG: {
                return isDistinct ? new DistinctAverageAggregationUnit() : new AverageAggregationUnit();
            }
        }
        throw new UnsupportedOperationException(type.name());
    }

    @Generated
    private AggregationUnitFactory() {
    }
}

