/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.select.pagination;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.NumberLiteralPaginationValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.ParameterMarkerPaginationValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.LimitValueSegment;

public final class PaginationContext {
    private final boolean hasPagination;
    private final PaginationValueSegment offsetSegment;
    private final PaginationValueSegment rowCountSegment;
    private final long actualOffset;
    private final Long actualRowCount;

    public PaginationContext(PaginationValueSegment offsetSegment, PaginationValueSegment rowCountSegment, List<Object> params) {
        this.hasPagination = null != offsetSegment || null != rowCountSegment;
        this.offsetSegment = offsetSegment;
        this.rowCountSegment = rowCountSegment;
        this.actualOffset = null == offsetSegment ? 0L : this.getValue(offsetSegment, params);
        this.actualRowCount = null == rowCountSegment ? null : Long.valueOf(this.getValue(rowCountSegment, params));
    }

    private long getValue(PaginationValueSegment paginationValueSegment, List<Object> params) {
        if (paginationValueSegment instanceof ParameterMarkerPaginationValueSegment) {
            Long obj = null == params || params.isEmpty() ? Long.valueOf(0L) : params.get(((ParameterMarkerPaginationValueSegment)paginationValueSegment).getParameterIndex());
            return obj instanceof Long ? obj : (long)((Integer)((Object)obj)).intValue();
        }
        return ((NumberLiteralPaginationValueSegment)paginationValueSegment).getValue();
    }

    public Optional<PaginationValueSegment> getOffsetSegment() {
        return Optional.ofNullable(this.offsetSegment);
    }

    public Optional<PaginationValueSegment> getRowCountSegment() {
        return Optional.ofNullable(this.rowCountSegment);
    }

    public long getActualOffset() {
        if (null == this.offsetSegment) {
            return 0L;
        }
        return this.offsetSegment.isBoundOpened() ? this.actualOffset - 1L : this.actualOffset;
    }

    public Optional<Long> getActualRowCount() {
        if (null == this.rowCountSegment) {
            return Optional.empty();
        }
        return Optional.of(this.rowCountSegment.isBoundOpened() ? this.actualRowCount + 1L : this.actualRowCount);
    }

    public Optional<Integer> getOffsetParameterIndex() {
        return this.offsetSegment instanceof ParameterMarkerPaginationValueSegment ? Optional.of(((ParameterMarkerPaginationValueSegment)this.offsetSegment).getParameterIndex()) : Optional.empty();
    }

    public Optional<Integer> getRowCountParameterIndex() {
        return this.rowCountSegment instanceof ParameterMarkerPaginationValueSegment ? Optional.of(((ParameterMarkerPaginationValueSegment)this.rowCountSegment).getParameterIndex()) : Optional.empty();
    }

    public long getRevisedOffset() {
        return 0L;
    }

    public long getRevisedRowCount(SelectStatementContext selectStatementContext) {
        if (this.isMaxRowCount(selectStatementContext)) {
            return Integer.MAX_VALUE;
        }
        return this.rowCountSegment instanceof LimitValueSegment ? this.actualOffset + this.actualRowCount : this.actualRowCount;
    }

    private boolean isMaxRowCount(SelectStatementContext selectStatementContext) {
        return (!selectStatementContext.getGroupByContext().getItems().isEmpty() || !selectStatementContext.getProjectionsContext().getAggregationProjections().isEmpty()) && !selectStatementContext.isSameGroupByAndOrderByItems();
    }

    @Generated
    public boolean isHasPagination() {
        return this.hasPagination;
    }
}

