/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.dml;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.aware.ParameterAware;
import org.apache.shardingsphere.infra.binder.context.segment.select.groupby.GroupByContext;
import org.apache.shardingsphere.infra.binder.context.segment.select.groupby.engine.GroupByContextEngine;
import org.apache.shardingsphere.infra.binder.context.segment.select.orderby.OrderByContext;
import org.apache.shardingsphere.infra.binder.context.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.context.segment.select.orderby.engine.OrderByContextEngine;
import org.apache.shardingsphere.infra.binder.context.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.infra.binder.context.segment.select.pagination.engine.PaginationContextEngine;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.engine.ProjectionsContextEngine;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ParameterMarkerProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.SubqueryProjection;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.context.type.WhereAvailable;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.identifier.type.TableContainedRule;
import org.apache.shardingsphere.sql.parser.sql.common.enums.ParameterMarkerType;
import org.apache.shardingsphere.sql.parser.sql.common.enums.SubqueryType;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.TextOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionExtractUtils;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtils;
import org.apache.shardingsphere.sql.parser.sql.common.util.SubqueryExtractUtils;
import org.apache.shardingsphere.sql.parser.sql.common.util.WhereExtractUtils;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class SelectStatementContext
extends CommonSQLStatementContext
implements TableAvailable,
WhereAvailable,
ParameterAware {
    private final TablesContext tablesContext;
    private final ProjectionsContext projectionsContext;
    private final GroupByContext groupByContext;
    private final OrderByContext orderByContext;
    private final Map<Integer, SelectStatementContext> subqueryContexts;
    private final Collection<WhereSegment> whereSegments = new LinkedList<WhereSegment>();
    private final Collection<ColumnSegment> columnSegments = new LinkedList<ColumnSegment>();
    private final Collection<BinaryOperationExpression> joinConditions = new LinkedList<BinaryOperationExpression>();
    private final boolean containsEnhancedTable;
    private SubqueryType subqueryType;
    private boolean needAggregateRewrite;
    private PaginationContext paginationContext;

    public SelectStatementContext(ShardingSphereMetaData metaData, List<Object> params, SelectStatement sqlStatement, String defaultDatabaseName) {
        super((SQLStatement)sqlStatement);
        this.extractWhereSegments(this.whereSegments, sqlStatement);
        ColumnExtractor.extractColumnSegments(this.columnSegments, this.whereSegments);
        ExpressionExtractUtils.extractJoinConditions(this.joinConditions, this.whereSegments);
        this.subqueryContexts = this.createSubqueryContexts(metaData, params, defaultDatabaseName);
        this.tablesContext = new TablesContext(this.getAllTableSegments(), this.subqueryContexts, this.getDatabaseType());
        this.groupByContext = new GroupByContextEngine().createGroupByContext(sqlStatement);
        this.orderByContext = new OrderByContextEngine().createOrderBy(sqlStatement, this.groupByContext);
        this.projectionsContext = new ProjectionsContextEngine(this.getDatabaseType()).createProjectionsContext(this.getSqlStatement().getFrom(), this.getSqlStatement().getProjections(), this.groupByContext, this.orderByContext);
        this.paginationContext = new PaginationContextEngine().createPaginationContext(sqlStatement, this.projectionsContext, params, this.whereSegments);
        String databaseName = this.tablesContext.getDatabaseName().orElse(defaultDatabaseName);
        this.containsEnhancedTable = this.isContainsEnhancedTable(metaData, databaseName, this.getTablesContext().getTableNames());
    }

    private boolean isContainsEnhancedTable(ShardingSphereMetaData metaData, String databaseName, Collection<String> tableNames) {
        for (TableContainedRule each : this.getTableContainedRules(metaData, databaseName)) {
            for (String tableName : tableNames) {
                if (!each.getEnhancedTableMapper().contains(tableName)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<TableContainedRule> getTableContainedRules(ShardingSphereMetaData metaData, String databaseName) {
        if (null == databaseName) {
            ShardingSpherePreconditions.checkState((boolean)this.tablesContext.getSimpleTableSegments().isEmpty(), NoDatabaseSelectedException::new);
            return Collections.emptyList();
        }
        ShardingSphereDatabase database = metaData.getDatabase(databaseName);
        ShardingSpherePreconditions.checkNotNull((Object)database, () -> new UnknownDatabaseException(databaseName));
        return database.getRuleMetaData().findRules(TableContainedRule.class);
    }

    private Map<Integer, SelectStatementContext> createSubqueryContexts(ShardingSphereMetaData metaData, List<Object> params, String defaultDatabaseName) {
        Collection subquerySegments = SubqueryExtractUtils.getSubquerySegments((SelectStatement)this.getSqlStatement());
        HashMap<Integer, SelectStatementContext> result = new HashMap<Integer, SelectStatementContext>(subquerySegments.size(), 1.0f);
        for (SubquerySegment each : subquerySegments) {
            SelectStatementContext subqueryContext = new SelectStatementContext(metaData, params, each.getSelect(), defaultDatabaseName);
            subqueryContext.setSubqueryType(each.getSubqueryType());
            result.put(each.getStartIndex(), subqueryContext);
        }
        return result;
    }

    public boolean isContainsJoinQuery() {
        return this.getSqlStatement().getFrom() instanceof JoinTableSegment;
    }

    public boolean isContainsSubquery() {
        return !this.subqueryContexts.isEmpty();
    }

    public boolean isContainsHaving() {
        return this.getSqlStatement().getHaving().isPresent();
    }

    public boolean isContainsCombine() {
        return this.getSqlStatement().getCombine().isPresent();
    }

    public boolean isContainsDollarParameterMarker() {
        for (Projection projection : this.projectionsContext.getProjections()) {
            if (!(projection instanceof ParameterMarkerProjection) || ParameterMarkerType.DOLLAR != ((ParameterMarkerProjection)projection).getParameterMarkerType()) continue;
            return true;
        }
        for (ParameterMarkerExpressionSegment parameterMarkerExpressionSegment : this.getParameterMarkerExpressions()) {
            if (ParameterMarkerType.DOLLAR != parameterMarkerExpressionSegment.getParameterMarkerType()) continue;
            return true;
        }
        return false;
    }

    private Collection<ParameterMarkerExpressionSegment> getParameterMarkerExpressions() {
        LinkedList<ExpressionSegment> expressions = new LinkedList<ExpressionSegment>();
        for (WhereSegment each : this.whereSegments) {
            expressions.add(each.getExpr());
        }
        return ExpressionExtractUtils.getParameterMarkerExpressions(expressions);
    }

    public boolean isContainsPartialDistinctAggregation() {
        Collection aggregationProjections = this.projectionsContext.getProjections().stream().filter(AggregationProjection.class::isInstance).collect(Collectors.toList());
        Collection<AggregationDistinctProjection> aggregationDistinctProjections = this.projectionsContext.getAggregationDistinctProjections();
        return aggregationProjections.size() > 1 && !aggregationDistinctProjections.isEmpty() && aggregationProjections.size() != aggregationDistinctProjections.size();
    }

    public void setIndexes(Map<String, Integer> columnLabelIndexMap) {
        this.setIndexForAggregationProjection(columnLabelIndexMap);
        this.setIndexForOrderItem(columnLabelIndexMap, this.orderByContext.getItems());
        this.setIndexForOrderItem(columnLabelIndexMap, this.groupByContext.getItems());
    }

    private void setIndexForAggregationProjection(Map<String, Integer> columnLabelIndexMap) {
        for (AggregationProjection each : this.projectionsContext.getAggregationProjections()) {
            String columnLabel = SQLUtils.getExactlyValue((String)each.getAlias().map(IdentifierValue::getValue).orElse(each.getColumnName()));
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(columnLabel), (String)"Can't find index: %s, please add alias for aggregate selections", (Object)each);
            each.setIndex(columnLabelIndexMap.get(columnLabel));
            for (AggregationProjection derived : each.getDerivedAggregationProjections()) {
                String derivedColumnLabel = SQLUtils.getExactlyValue((String)derived.getAlias().map(IdentifierValue::getValue).orElse(each.getColumnName()));
                Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(derivedColumnLabel), (String)"Can't find index: %s", (Object)derived);
                derived.setIndex(columnLabelIndexMap.get(derivedColumnLabel));
            }
        }
    }

    private void setIndexForOrderItem(Map<String, Integer> columnLabelIndexMap, Collection<OrderByItem> orderByItems) {
        for (OrderByItem each : orderByItems) {
            Optional<Integer> itemIndex;
            if (each.getSegment() instanceof IndexOrderByItemSegment) {
                each.setIndex(((IndexOrderByItemSegment)each.getSegment()).getColumnIndex());
                continue;
            }
            if (each.getSegment() instanceof ColumnOrderByItemSegment && ((ColumnOrderByItemSegment)each.getSegment()).getColumn().getOwner().isPresent() && (itemIndex = this.projectionsContext.findProjectionIndex(((ColumnOrderByItemSegment)each.getSegment()).getText())).isPresent()) {
                each.setIndex(itemIndex.get());
                continue;
            }
            String columnLabel = this.getAlias(each.getSegment()).orElseGet(() -> this.getOrderItemText((TextOrderByItemSegment)each.getSegment()));
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(columnLabel), (String)"Can't find index: %s", (Object)each);
            if (!columnLabelIndexMap.containsKey(columnLabel)) continue;
            each.setIndex(columnLabelIndexMap.get(columnLabel));
        }
    }

    private Optional<String> getAlias(OrderByItemSegment orderByItem) {
        if (this.projectionsContext.isUnqualifiedShorthandProjection()) {
            return Optional.empty();
        }
        String rawName = SQLUtils.getExactlyValue((String)((TextOrderByItemSegment)orderByItem).getText());
        for (Projection each : this.projectionsContext.getProjections()) {
            Optional<String> result = each.getAlias().map(IdentifierValue::getValue);
            if (SQLUtils.getExactlyExpression((String)rawName).equalsIgnoreCase(SQLUtils.getExactlyExpression((String)SQLUtils.getExactlyValue((String)each.getExpression())))) {
                return result;
            }
            if (rawName.equalsIgnoreCase(result.orElse(null))) {
                return Optional.of(rawName);
            }
            if (!this.isSameColumnName(each, rawName)) continue;
            return result;
        }
        return Optional.empty();
    }

    private boolean isSameColumnName(Projection projection, String name) {
        return projection instanceof ColumnProjection && name.equalsIgnoreCase(((ColumnProjection)projection).getName().getValue());
    }

    private String getOrderItemText(TextOrderByItemSegment orderByItemSegment) {
        if (orderByItemSegment instanceof ColumnOrderByItemSegment) {
            return SQLUtils.getExactlyValue((String)((ColumnOrderByItemSegment)orderByItemSegment).getColumn().getIdentifier().getValue());
        }
        return SQLUtils.getExactlyValue((String)((ExpressionOrderByItemSegment)orderByItemSegment).getExpression());
    }

    public boolean isSameGroupByAndOrderByItems() {
        return !this.groupByContext.getItems().isEmpty() && this.groupByContext.getItems().equals(this.orderByContext.getItems());
    }

    public Optional<ColumnProjection> findColumnProjection(int columnIndex) {
        List<Projection> expandProjections = this.projectionsContext.getExpandProjections();
        if (expandProjections.size() < columnIndex) {
            return Optional.empty();
        }
        Projection projection = expandProjections.get(columnIndex - 1);
        if (projection instanceof ColumnProjection) {
            return Optional.of((ColumnProjection)projection);
        }
        if (projection instanceof SubqueryProjection && ((SubqueryProjection)projection).getProjection() instanceof ColumnProjection) {
            return Optional.of((ColumnProjection)((SubqueryProjection)projection).getProjection());
        }
        return Optional.empty();
    }

    public SelectStatement getSqlStatement() {
        return (SelectStatement)super.getSqlStatement();
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        return this.tablesContext.getSimpleTableSegments();
    }

    @Override
    public Collection<WhereSegment> getWhereSegments() {
        return this.whereSegments;
    }

    @Override
    public Collection<ColumnSegment> getColumnSegments() {
        return this.columnSegments;
    }

    @Override
    public Collection<BinaryOperationExpression> getJoinConditions() {
        return this.joinConditions;
    }

    private void extractWhereSegments(Collection<WhereSegment> whereSegments, SelectStatement selectStatement) {
        selectStatement.getWhere().ifPresent(whereSegments::add);
        whereSegments.addAll(WhereExtractUtils.getSubqueryWhereSegments((SelectStatement)selectStatement));
        whereSegments.addAll(WhereExtractUtils.getJoinWhereSegments((SelectStatement)selectStatement));
    }

    private Collection<TableSegment> getAllTableSegments() {
        TableExtractor tableExtractor = new TableExtractor();
        tableExtractor.extractTablesFromSelect(this.getSqlStatement());
        LinkedList<TableSegment> result = new LinkedList<TableSegment>(tableExtractor.getRewriteTables());
        for (TableSegment each : tableExtractor.getTableContext()) {
            if (!(each instanceof SubqueryTableSegment)) continue;
            result.add(each);
        }
        return result;
    }

    public boolean containsTableSubquery() {
        return this.getSqlStatement().getFrom() instanceof SubqueryTableSegment;
    }

    @Override
    public void setUpParameters(List<Object> params) {
        this.paginationContext = new PaginationContextEngine().createPaginationContext(this.getSqlStatement(), this.projectionsContext, params, this.whereSegments);
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Generated
    public ProjectionsContext getProjectionsContext() {
        return this.projectionsContext;
    }

    @Generated
    public GroupByContext getGroupByContext() {
        return this.groupByContext;
    }

    @Generated
    public OrderByContext getOrderByContext() {
        return this.orderByContext;
    }

    @Generated
    public Map<Integer, SelectStatementContext> getSubqueryContexts() {
        return this.subqueryContexts;
    }

    @Generated
    public boolean isContainsEnhancedTable() {
        return this.containsEnhancedTable;
    }

    @Generated
    public SubqueryType getSubqueryType() {
        return this.subqueryType;
    }

    @Generated
    public boolean isNeedAggregateRewrite() {
        return this.needAggregateRewrite;
    }

    @Generated
    public PaginationContext getPaginationContext() {
        return this.paginationContext;
    }

    @Generated
    public void setSubqueryType(SubqueryType subqueryType) {
        this.subqueryType = subqueryType;
    }

    @Generated
    public void setNeedAggregateRewrite(boolean needAggregateRewrite) {
        this.needAggregateRewrite = needAggregateRewrite;
    }

    @Generated
    public void setPaginationContext(PaginationContext paginationContext) {
        this.paginationContext = paginationContext;
    }
}

