/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.expression.impl;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.groovy.util.Maps;
import org.apache.shardingsphere.infra.binder.enums.SegmentType;
import org.apache.shardingsphere.infra.binder.segment.from.FunctionTableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.segment.from.SimpleTableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.segment.from.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.exception.AmbiguousColumnException;
import org.apache.shardingsphere.infra.exception.UnknownColumnException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.bounded.ColumnSegmentBoundedInfo;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class ColumnSegmentBinder {
    private static final Collection<String> EXCLUDE_BIND_COLUMNS = new LinkedHashSet<String>(Arrays.asList("ROWNUM", "ROW_NUMBER", "ROWNUM_", "SYSDATE", "SYSTIMESTAMP", "CURRENT_TIMESTAMP", "LOCALTIMESTAMP", "UID", "USER", "NEXTVAL", "ROWID"));
    private static final Map<SegmentType, String> SEGMENT_TYPE_MESSAGES = Maps.of((Object)((Object)SegmentType.PROJECTION), (Object)"field list", (Object)((Object)SegmentType.JOIN_ON), (Object)"on clause", (Object)((Object)SegmentType.JOIN_USING), (Object)"from clause", (Object)((Object)SegmentType.PREDICATE), (Object)"where clause", (Object)((Object)SegmentType.ORDER_BY), (Object)"order clause", (Object)((Object)SegmentType.GROUP_BY), (Object)"group statement", (Object)((Object)SegmentType.INSERT_COLUMNS), (Object)"field list");
    private static final String UNKNOWN_SEGMENT_TYPE_MESSAGE = "unknown clause";

    public static ColumnSegment bind(ColumnSegment segment, SegmentType parentSegmentType, SQLStatementBinderContext statementBinderContext, Map<String, TableSegmentBinderContext> tableBinderContexts, Map<String, TableSegmentBinderContext> outerTableBinderContexts) {
        if (EXCLUDE_BIND_COLUMNS.contains(segment.getIdentifier().getValue().toUpperCase())) {
            return segment;
        }
        ColumnSegment result = new ColumnSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getIdentifier());
        segment.getOwner().ifPresent(arg_0 -> ((ColumnSegment)result).setOwner(arg_0));
        Collection<TableSegmentBinderContext> tableBinderContextValues = ColumnSegmentBinder.getTableSegmentBinderContexts(segment, parentSegmentType, statementBinderContext, tableBinderContexts, outerTableBinderContexts);
        Optional<ColumnSegment> inputColumnSegment = ColumnSegmentBinder.findInputColumnSegment(segment, parentSegmentType, tableBinderContextValues, outerTableBinderContexts, statementBinderContext);
        inputColumnSegment.ifPresent(optional -> result.setVariable(optional.isVariable()));
        result.setColumnBoundedInfo(ColumnSegmentBinder.createColumnSegmentBoundedInfo(segment, inputColumnSegment.orElse(null)));
        return result;
    }

    private static Collection<TableSegmentBinderContext> getTableSegmentBinderContexts(ColumnSegment segment, SegmentType parentSegmentType, SQLStatementBinderContext statementBinderContext, Map<String, TableSegmentBinderContext> tableBinderContexts, Map<String, TableSegmentBinderContext> outerTableBinderContexts) {
        if (segment.getOwner().isPresent()) {
            return ColumnSegmentBinder.getTableBinderContextByOwner(((OwnerSegment)segment.getOwner().get()).getIdentifier().getValue().toLowerCase(), tableBinderContexts, outerTableBinderContexts, statementBinderContext.getExternalTableBinderContexts());
        }
        if (!statementBinderContext.getJoinTableProjectionSegments().isEmpty() && ColumnSegmentBinder.isNeedUseJoinTableProjectionBind(segment, parentSegmentType, statementBinderContext)) {
            return Collections.singleton(new SimpleTableSegmentBinderContext(statementBinderContext.getJoinTableProjectionSegments()));
        }
        return tableBinderContexts.values();
    }

    private static boolean isNeedUseJoinTableProjectionBind(ColumnSegment segment, SegmentType parentSegmentType, SQLStatementBinderContext statementBinderContext) {
        return SegmentType.PROJECTION == parentSegmentType || SegmentType.PREDICATE == parentSegmentType && statementBinderContext.getUsingColumnNames().contains(segment.getIdentifier().getValue().toLowerCase());
    }

    private static Collection<TableSegmentBinderContext> getTableBinderContextByOwner(String owner, Map<String, TableSegmentBinderContext> tableBinderContexts, Map<String, TableSegmentBinderContext> outerTableBinderContexts, Map<String, TableSegmentBinderContext> externalTableBinderContexts) {
        if (tableBinderContexts.containsKey(owner)) {
            return Collections.singleton(tableBinderContexts.get(owner));
        }
        if (outerTableBinderContexts.containsKey(owner)) {
            return Collections.singleton(outerTableBinderContexts.get(owner));
        }
        if (externalTableBinderContexts.containsKey(owner)) {
            return Collections.singleton(externalTableBinderContexts.get(owner));
        }
        return Collections.emptyList();
    }

    private static Optional<ColumnSegment> findInputColumnSegment(ColumnSegment segment, SegmentType parentSegmentType, Collection<TableSegmentBinderContext> tableBinderContexts, Map<String, TableSegmentBinderContext> outerTableBinderContexts, SQLStatementBinderContext statementBinderContext) {
        Optional<ProjectionSegment> projectionSegment;
        ColumnSegment result = null;
        boolean isFindInputColumn = false;
        for (TableSegmentBinderContext each : tableBinderContexts) {
            Optional<ProjectionSegment> projectionSegment2 = each.findProjectionSegmentByColumnLabel(segment.getIdentifier().getValue());
            if (projectionSegment2.isPresent() && projectionSegment2.get() instanceof ColumnProjectionSegment) {
                ShardingSpherePreconditions.checkState((null == result ? 1 : 0) != 0, () -> new AmbiguousColumnException(segment.getExpression(), SEGMENT_TYPE_MESSAGES.getOrDefault((Object)parentSegmentType, UNKNOWN_SEGMENT_TYPE_MESSAGE)));
                result = ((ColumnProjectionSegment)projectionSegment2.get()).getColumn();
            }
            if (isFindInputColumn || !projectionSegment2.isPresent()) continue;
            isFindInputColumn = true;
        }
        if (!isFindInputColumn) {
            projectionSegment = ColumnSegmentBinder.findInputColumnSegmentFromOuterTable(segment, outerTableBinderContexts);
            isFindInputColumn = projectionSegment.isPresent();
            if (projectionSegment.isPresent() && projectionSegment.get() instanceof ColumnProjectionSegment) {
                result = ((ColumnProjectionSegment)projectionSegment.get()).getColumn();
            }
        }
        if (!isFindInputColumn) {
            projectionSegment = ColumnSegmentBinder.findInputColumnSegmentFromExternalTables(segment, statementBinderContext.getExternalTableBinderContexts());
            isFindInputColumn = projectionSegment.isPresent();
            if (projectionSegment.isPresent() && projectionSegment.get() instanceof ColumnProjectionSegment) {
                result = ((ColumnProjectionSegment)projectionSegment.get()).getColumn();
            }
        }
        if (!isFindInputColumn) {
            result = ColumnSegmentBinder.findInputColumnSegmentByVariables(segment, statementBinderContext.getVariableNames()).orElse(null);
            boolean bl = isFindInputColumn = result != null;
        }
        if (!isFindInputColumn) {
            result = ColumnSegmentBinder.findInputColumnSegmentByPivotColumns(segment, statementBinderContext.getPivotColumnNames()).orElse(null);
            isFindInputColumn = result != null;
        }
        ShardingSpherePreconditions.checkState((isFindInputColumn || ColumnSegmentBinder.containsFunctionTable(tableBinderContexts, outerTableBinderContexts.values()) ? 1 : 0) != 0, () -> new UnknownColumnException(segment.getExpression(), SEGMENT_TYPE_MESSAGES.getOrDefault((Object)parentSegmentType, UNKNOWN_SEGMENT_TYPE_MESSAGE)));
        return Optional.ofNullable(result);
    }

    private static Optional<ColumnSegment> findInputColumnSegmentByPivotColumns(ColumnSegment segment, Collection<String> pivotColumnNames) {
        if (pivotColumnNames.isEmpty()) {
            return Optional.empty();
        }
        if (pivotColumnNames.contains(segment.getIdentifier().getValue().toLowerCase())) {
            return Optional.of(new ColumnSegment(0, 0, segment.getIdentifier()));
        }
        return Optional.empty();
    }

    private static Optional<ProjectionSegment> findInputColumnSegmentFromOuterTable(ColumnSegment segment, Map<String, TableSegmentBinderContext> outerTableBinderContexts) {
        ListIterator<TableSegmentBinderContext> listIterator = new ArrayList<TableSegmentBinderContext>(outerTableBinderContexts.values()).listIterator(outerTableBinderContexts.size());
        while (listIterator.hasPrevious()) {
            TableSegmentBinderContext each = listIterator.previous();
            Optional<ProjectionSegment> result = each.findProjectionSegmentByColumnLabel(segment.getIdentifier().getValue());
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    private static Optional<ProjectionSegment> findInputColumnSegmentFromExternalTables(ColumnSegment segment, Map<String, TableSegmentBinderContext> externalTableBinderContexts) {
        for (TableSegmentBinderContext each : externalTableBinderContexts.values()) {
            Optional<ProjectionSegment> result = each.findProjectionSegmentByColumnLabel(segment.getIdentifier().getValue());
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    private static Optional<ColumnSegment> findInputColumnSegmentByVariables(ColumnSegment segment, Collection<String> variableNames) {
        if (variableNames.isEmpty()) {
            return Optional.empty();
        }
        if (variableNames.contains(segment.getIdentifier().getValue().toLowerCase())) {
            ColumnSegment result = new ColumnSegment(0, 0, segment.getIdentifier());
            result.setVariable(true);
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private static boolean containsFunctionTable(Collection<TableSegmentBinderContext> tableBinderContexts, Collection<TableSegmentBinderContext> outerBinderContexts) {
        for (TableSegmentBinderContext each : tableBinderContexts) {
            if (!(each instanceof FunctionTableSegmentBinderContext)) continue;
            return true;
        }
        for (TableSegmentBinderContext each : outerBinderContexts) {
            if (!(each instanceof FunctionTableSegmentBinderContext)) continue;
            return true;
        }
        return false;
    }

    private static ColumnSegmentBoundedInfo createColumnSegmentBoundedInfo(ColumnSegment segment, ColumnSegment inputColumnSegment) {
        IdentifierValue originalDatabase = null == inputColumnSegment ? null : inputColumnSegment.getColumnBoundedInfo().getOriginalDatabase();
        IdentifierValue originalSchema = null == inputColumnSegment ? null : inputColumnSegment.getColumnBoundedInfo().getOriginalSchema();
        IdentifierValue segmentOriginalTable = segment.getColumnBoundedInfo().getOriginalTable();
        IdentifierValue originalTable = Strings.isNullOrEmpty((String)segmentOriginalTable.getValue()) ? Optional.ofNullable(inputColumnSegment).map(optional -> optional.getColumnBoundedInfo().getOriginalTable()).orElse(segmentOriginalTable) : segmentOriginalTable;
        IdentifierValue segmentOriginalColumn = segment.getColumnBoundedInfo().getOriginalColumn();
        IdentifierValue originalColumn = Strings.isNullOrEmpty((String)segmentOriginalColumn.getValue()) ? Optional.ofNullable(inputColumnSegment).map(optional -> optional.getColumnBoundedInfo().getOriginalColumn()).orElse(segmentOriginalColumn) : segmentOriginalColumn;
        return new ColumnSegmentBoundedInfo(originalDatabase, originalSchema, originalTable, originalColumn);
    }

    public static ColumnSegment bindUsingColumn(ColumnSegment segment, SegmentType parentSegmentType, Map<String, TableSegmentBinderContext> tableBinderContexts) {
        ColumnSegment result = new ColumnSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getIdentifier());
        segment.getOwner().ifPresent(arg_0 -> ((ColumnSegment)result).setOwner(arg_0));
        Collection<TableSegmentBinderContext> tableBinderContextValues = tableBinderContexts.values();
        Collection<ColumnSegment> usingInputColumnSegments = ColumnSegmentBinder.findUsingInputColumnSegments(segment.getIdentifier().getValue(), tableBinderContextValues);
        ShardingSpherePreconditions.checkState((usingInputColumnSegments.size() >= 2 ? 1 : 0) != 0, () -> new UnknownColumnException(segment.getExpression(), SEGMENT_TYPE_MESSAGES.getOrDefault((Object)parentSegmentType, UNKNOWN_SEGMENT_TYPE_MESSAGE)));
        Iterator<ColumnSegment> iterator = usingInputColumnSegments.iterator();
        result.setColumnBoundedInfo(ColumnSegmentBinder.createColumnSegmentBoundedInfo(segment, iterator.next()));
        result.setOtherUsingColumnBoundedInfo(ColumnSegmentBinder.createColumnSegmentBoundedInfo(segment, iterator.next()));
        return result;
    }

    private static Collection<ColumnSegment> findUsingInputColumnSegments(String columnName, Collection<TableSegmentBinderContext> tableBinderContexts) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        for (TableSegmentBinderContext each : tableBinderContexts) {
            Optional<ProjectionSegment> projectionSegment = each.findProjectionSegmentByColumnLabel(columnName);
            if (!projectionSegment.isPresent() || !(projectionSegment.get() instanceof ColumnProjectionSegment)) continue;
            result.add(((ColumnProjectionSegment)projectionSegment.get()).getColumn());
        }
        return result;
    }

    @Generated
    private ColumnSegmentBinder() {
    }
}

