/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.from.impl;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.from.SimpleTableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.segment.from.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementBinder;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.bounded.ColumnSegmentBoundedInfo;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class SubqueryTableSegmentBinder {
    public static SubqueryTableSegment bind(SubqueryTableSegment segment, SQLStatementBinderContext statementBinderContext, Map<String, TableSegmentBinderContext> tableBinderContexts, Map<String, TableSegmentBinderContext> outerTableBinderContexts) {
        SubqueryTableSegmentBinder.fillPivotColumnNamesInBinderContext(segment, statementBinderContext);
        SelectStatement boundedSelect = new SelectStatementBinder().bindCorrelateSubquery(segment.getSubquery().getSelect(), statementBinderContext.getMetaData(), statementBinderContext.getDefaultDatabaseName(), outerTableBinderContexts, statementBinderContext.getExternalTableBinderContexts());
        SubquerySegment boundedSubquerySegment = new SubquerySegment(segment.getSubquery().getStartIndex(), segment.getSubquery().getStopIndex(), boundedSelect);
        boundedSubquerySegment.setSubqueryType(segment.getSubquery().getSubqueryType());
        SubqueryTableSegment result = new SubqueryTableSegment(boundedSubquerySegment);
        segment.getAliasSegment().ifPresent(arg_0 -> ((SubqueryTableSegment)result).setAlias(arg_0));
        IdentifierValue subqueryTableName = segment.getAliasSegment().map(AliasSegment::getIdentifier).orElseGet(() -> new IdentifierValue(""));
        tableBinderContexts.put(subqueryTableName.getValue().toLowerCase(), new SimpleTableSegmentBinderContext(SubqueryTableSegmentBinder.createSubqueryProjections(boundedSelect.getProjections().getProjections(), subqueryTableName)));
        return result;
    }

    private static void fillPivotColumnNamesInBinderContext(SubqueryTableSegment segment, SQLStatementBinderContext statementBinderContext) {
        segment.getPivot().ifPresent(optional -> optional.getPivotColumns().forEach(each -> statementBinderContext.getPivotColumnNames().add(each.getIdentifier().getValue().toLowerCase())));
    }

    private static Collection<ProjectionSegment> createSubqueryProjections(Collection<ProjectionSegment> projections, IdentifierValue subqueryTableName) {
        LinkedList<ProjectionSegment> result = new LinkedList<ProjectionSegment>();
        for (ProjectionSegment each : projections) {
            if (each instanceof ColumnProjectionSegment) {
                result.add((ProjectionSegment)SubqueryTableSegmentBinder.createColumnProjection((ColumnProjectionSegment)each, subqueryTableName));
                continue;
            }
            if (each instanceof ShorthandProjectionSegment) {
                result.addAll(SubqueryTableSegmentBinder.createSubqueryProjections(((ShorthandProjectionSegment)each).getActualProjectionSegments(), subqueryTableName));
                continue;
            }
            result.add(each);
        }
        return result;
    }

    private static ColumnProjectionSegment createColumnProjection(ColumnProjectionSegment originalColumn, IdentifierValue subqueryTableName) {
        ColumnSegment newColumnSegment = new ColumnSegment(0, 0, originalColumn.getAlias().orElseGet(() -> originalColumn.getColumn().getIdentifier()));
        if (!Strings.isNullOrEmpty((String)subqueryTableName.getValue())) {
            newColumnSegment.setOwner(new OwnerSegment(0, 0, subqueryTableName));
        }
        newColumnSegment.setColumnBoundedInfo(new ColumnSegmentBoundedInfo(originalColumn.getColumn().getColumnBoundedInfo().getOriginalDatabase(), originalColumn.getColumn().getColumnBoundedInfo().getOriginalSchema(), originalColumn.getColumn().getColumnBoundedInfo().getOriginalTable(), originalColumn.getColumn().getColumnBoundedInfo().getOriginalColumn()));
        ColumnProjectionSegment result = new ColumnProjectionSegment(newColumnSegment);
        result.setVisible(originalColumn.isVisible());
        return result;
    }

    @Generated
    private SubqueryTableSegmentBinder() {
    }
}

