/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement.dml;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.segment.column.InsertColumnsSegmentBinder;
import org.apache.shardingsphere.infra.binder.segment.expression.impl.SubquerySegmentBinder;
import org.apache.shardingsphere.infra.binder.segment.from.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.segment.from.impl.SimpleTableSegmentBinder;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.ReturningSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.OnDuplicateKeyColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OutputSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.WithSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;
import org.apache.shardingsphere.sql.parser.sql.dialect.segment.oracle.insert.MultiTableConditionalIntoSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.segment.oracle.insert.MultiTableInsertIntoSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.segment.oracle.insert.MultiTableInsertType;

public final class InsertStatementBinder
implements SQLStatementBinder<InsertStatement> {
    @Override
    public InsertStatement bind(InsertStatement sqlStatement, ShardingSphereMetaData metaData, String defaultDatabaseName) {
        return this.bind(sqlStatement, metaData, defaultDatabaseName, Collections.emptyMap());
    }

    private InsertStatement bind(InsertStatement sqlStatement, ShardingSphereMetaData metaData, String defaultDatabaseName, Map<String, TableSegmentBinderContext> externalTableBinderContexts) {
        InsertStatement result = (InsertStatement)sqlStatement.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        SQLStatementBinderContext statementBinderContext = new SQLStatementBinderContext(metaData, defaultDatabaseName, sqlStatement.getDatabaseType(), sqlStatement.getVariableNames());
        statementBinderContext.getExternalTableBinderContexts().putAll(externalTableBinderContexts);
        LinkedHashMap<String, TableSegmentBinderContext> tableBinderContexts = new LinkedHashMap<String, TableSegmentBinderContext>();
        Optional.ofNullable(sqlStatement.getTable()).ifPresent(optional -> result.setTable(SimpleTableSegmentBinder.bind(optional, statementBinderContext, tableBinderContexts)));
        if (sqlStatement.getInsertColumns().isPresent() && !((InsertColumnsSegment)sqlStatement.getInsertColumns().get()).getColumns().isEmpty()) {
            result.setInsertColumns(InsertColumnsSegmentBinder.bind((InsertColumnsSegment)sqlStatement.getInsertColumns().get(), statementBinderContext, tableBinderContexts));
        } else {
            sqlStatement.getInsertColumns().ifPresent(arg_0 -> ((InsertStatement)result).setInsertColumns(arg_0));
            tableBinderContexts.values().forEach(each -> result.getDerivedInsertColumns().addAll(this.getVisibleColumns(each.getProjectionSegments())));
        }
        sqlStatement.getInsertSelect().ifPresent(optional -> result.setInsertSelect(SubquerySegmentBinder.bind(optional, statementBinderContext, tableBinderContexts)));
        result.getValues().addAll(sqlStatement.getValues());
        InsertStatementHandler.getOnDuplicateKeyColumnsSegment((InsertStatement)sqlStatement).ifPresent(optional -> InsertStatementHandler.setOnDuplicateKeyColumnsSegment((InsertStatement)result, (OnDuplicateKeyColumnsSegment)optional));
        InsertStatementHandler.getSetAssignmentSegment((InsertStatement)sqlStatement).ifPresent(optional -> InsertStatementHandler.setSetAssignmentSegment((InsertStatement)result, (SetAssignmentSegment)optional));
        InsertStatementHandler.getWithSegment((InsertStatement)sqlStatement).ifPresent(optional -> InsertStatementHandler.setWithSegment((InsertStatement)result, (WithSegment)optional));
        InsertStatementHandler.getOutputSegment((InsertStatement)sqlStatement).ifPresent(optional -> InsertStatementHandler.setOutputSegment((InsertStatement)result, (OutputSegment)optional));
        InsertStatementHandler.getMultiTableInsertType((InsertStatement)sqlStatement).ifPresent(optional -> InsertStatementHandler.setMultiTableInsertType((InsertStatement)result, (MultiTableInsertType)optional));
        InsertStatementHandler.getMultiTableInsertIntoSegment((InsertStatement)sqlStatement).ifPresent(optional -> InsertStatementHandler.setMultiTableInsertIntoSegment((InsertStatement)result, (MultiTableInsertIntoSegment)optional));
        InsertStatementHandler.getMultiTableConditionalIntoSegment((InsertStatement)sqlStatement).ifPresent(optional -> InsertStatementHandler.setMultiTableConditionalIntoSegment((InsertStatement)result, (MultiTableConditionalIntoSegment)optional));
        InsertStatementHandler.getReturningSegment((InsertStatement)sqlStatement).ifPresent(optional -> InsertStatementHandler.setReturningSegment((InsertStatement)result, (ReturningSegment)optional));
        result.addParameterMarkerSegments(sqlStatement.getParameterMarkerSegments());
        result.getCommentSegments().addAll(sqlStatement.getCommentSegments());
        return result;
    }

    private Collection<ColumnSegment> getVisibleColumns(Collection<ProjectionSegment> projectionSegments) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        for (ProjectionSegment each : projectionSegments) {
            if (!(each instanceof ColumnProjectionSegment) || !each.isVisible()) continue;
            result.add(((ColumnProjectionSegment)each).getColumn());
        }
        return result;
    }
}

