/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement.dml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.shardingsphere.infra.binder.enums.SegmentType;
import org.apache.shardingsphere.infra.binder.segment.expression.ExpressionSegmentBinder;
import org.apache.shardingsphere.infra.binder.segment.expression.impl.ColumnSegmentBinder;
import org.apache.shardingsphere.infra.binder.segment.from.TableSegmentBinder;
import org.apache.shardingsphere.infra.binder.segment.from.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.segment.where.WhereSegmentBinder;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.ReturningSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.ColumnAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.OnDuplicateKeyColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionWithParamsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OutputSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.WithSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.MergeStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.UpdateStatementHandler;
import org.apache.shardingsphere.sql.parser.sql.dialect.segment.oracle.insert.MultiTableConditionalIntoSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.segment.oracle.insert.MultiTableInsertIntoSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.segment.oracle.insert.MultiTableInsertType;

public final class MergeStatementBinder
implements SQLStatementBinder<MergeStatement> {
    @Override
    public MergeStatement bind(MergeStatement sqlStatement, ShardingSphereMetaData metaData, String defaultDatabaseName) {
        return this.bind(sqlStatement, metaData, defaultDatabaseName, Collections.emptyMap());
    }

    private MergeStatement bind(MergeStatement sqlStatement, ShardingSphereMetaData metaData, String defaultDatabaseName, Map<String, TableSegmentBinderContext> externalTableBinderContexts) {
        MergeStatement result = (MergeStatement)sqlStatement.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        SQLStatementBinderContext statementBinderContext = new SQLStatementBinderContext(metaData, defaultDatabaseName, sqlStatement.getDatabaseType(), sqlStatement.getVariableNames());
        statementBinderContext.getExternalTableBinderContexts().putAll(externalTableBinderContexts);
        CaseInsensitiveMap targetTableBinderContexts = new CaseInsensitiveMap();
        TableSegment boundedTargetTableSegment = TableSegmentBinder.bind(sqlStatement.getTarget(), statementBinderContext, (Map<String, TableSegmentBinderContext>)targetTableBinderContexts, Collections.emptyMap());
        CaseInsensitiveMap sourceTableBinderContexts = new CaseInsensitiveMap();
        TableSegment boundedSourceTableSegment = TableSegmentBinder.bind(sqlStatement.getSource(), statementBinderContext, (Map<String, TableSegmentBinderContext>)sourceTableBinderContexts, Collections.emptyMap());
        result.setTarget(boundedTargetTableSegment);
        result.setSource(boundedSourceTableSegment);
        LinkedHashMap<String, TableSegmentBinderContext> tableBinderContexts = new LinkedHashMap<String, TableSegmentBinderContext>();
        tableBinderContexts.putAll((Map<String, TableSegmentBinderContext>)sourceTableBinderContexts);
        tableBinderContexts.putAll((Map<String, TableSegmentBinderContext>)targetTableBinderContexts);
        if (sqlStatement.getExpression() != null) {
            ExpressionWithParamsSegment expression = new ExpressionWithParamsSegment(sqlStatement.getExpression().getStartIndex(), sqlStatement.getExpression().getStopIndex(), ExpressionSegmentBinder.bind(sqlStatement.getExpression().getExpr(), SegmentType.JOIN_ON, statementBinderContext, tableBinderContexts, Collections.emptyMap()));
            expression.getParameterMarkerSegments().addAll(sqlStatement.getExpression().getParameterMarkerSegments());
            result.setExpression(expression);
        }
        result.setInsert((InsertStatement)Optional.ofNullable(sqlStatement.getInsert()).map(arg_0 -> this.lambda$bind$0(boundedTargetTableSegment, statementBinderContext, (Map)targetTableBinderContexts, (Map)sourceTableBinderContexts, arg_0)).orElse(null));
        result.setUpdate((UpdateStatement)Optional.ofNullable(sqlStatement.getUpdate()).map(arg_0 -> this.lambda$bind$1(boundedTargetTableSegment, statementBinderContext, (Map)targetTableBinderContexts, (Map)sourceTableBinderContexts, arg_0)).orElse(null));
        result.addParameterMarkerSegments(sqlStatement.getParameterMarkerSegments());
        result.getCommentSegments().addAll(sqlStatement.getCommentSegments());
        return result;
    }

    private InsertStatement bindMergeInsert(InsertStatement sqlStatement, SimpleTableSegment tableSegment, SQLStatementBinderContext statementBinderContext, Map<String, TableSegmentBinderContext> targetTableBinderContexts, Map<String, TableSegmentBinderContext> sourceTableBinderContexts) {
        InsertStatement result = (InsertStatement)sqlStatement.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        result.setTable(tableSegment);
        sqlStatement.getInsertColumns().ifPresent(arg_0 -> ((InsertStatement)result).setInsertColumns(arg_0));
        sqlStatement.getInsertSelect().ifPresent(arg_0 -> ((InsertStatement)result).setInsertSelect(arg_0));
        SQLStatementBinderContext insertStatementBinderContext = new SQLStatementBinderContext(statementBinderContext.getMetaData(), statementBinderContext.getDefaultDatabaseName(), statementBinderContext.getDatabaseType(), statementBinderContext.getVariableNames());
        insertStatementBinderContext.getExternalTableBinderContexts().putAll(statementBinderContext.getExternalTableBinderContexts());
        insertStatementBinderContext.getExternalTableBinderContexts().putAll(sourceTableBinderContexts);
        LinkedList<InsertValuesSegment> insertValues = new LinkedList<InsertValuesSegment>();
        for (InsertValuesSegment each : sqlStatement.getValues()) {
            LinkedList<ExpressionSegment> values = new LinkedList<ExpressionSegment>();
            for (ExpressionSegment value : each.getValues()) {
                values.add(ExpressionSegmentBinder.bind(value, SegmentType.VALUES, insertStatementBinderContext, targetTableBinderContexts, sourceTableBinderContexts));
            }
            insertValues.add(new InsertValuesSegment(each.getStartIndex(), each.getStopIndex(), values));
        }
        result.getValues().addAll(insertValues);
        InsertStatementHandler.getOnDuplicateKeyColumnsSegment((InsertStatement)sqlStatement).ifPresent(optional -> InsertStatementHandler.setOnDuplicateKeyColumnsSegment((InsertStatement)result, (OnDuplicateKeyColumnsSegment)optional));
        InsertStatementHandler.getSetAssignmentSegment((InsertStatement)sqlStatement).ifPresent(optional -> InsertStatementHandler.setSetAssignmentSegment((InsertStatement)result, (SetAssignmentSegment)optional));
        InsertStatementHandler.getWithSegment((InsertStatement)sqlStatement).ifPresent(optional -> InsertStatementHandler.setWithSegment((InsertStatement)result, (WithSegment)optional));
        InsertStatementHandler.getOutputSegment((InsertStatement)sqlStatement).ifPresent(optional -> InsertStatementHandler.setOutputSegment((InsertStatement)result, (OutputSegment)optional));
        InsertStatementHandler.getMultiTableInsertType((InsertStatement)sqlStatement).ifPresent(optional -> InsertStatementHandler.setMultiTableInsertType((InsertStatement)result, (MultiTableInsertType)optional));
        InsertStatementHandler.getMultiTableInsertIntoSegment((InsertStatement)sqlStatement).ifPresent(optional -> InsertStatementHandler.setMultiTableInsertIntoSegment((InsertStatement)result, (MultiTableInsertIntoSegment)optional));
        InsertStatementHandler.getMultiTableConditionalIntoSegment((InsertStatement)sqlStatement).ifPresent(optional -> InsertStatementHandler.setMultiTableConditionalIntoSegment((InsertStatement)result, (MultiTableConditionalIntoSegment)optional));
        InsertStatementHandler.getReturningSegment((InsertStatement)sqlStatement).ifPresent(optional -> InsertStatementHandler.setReturningSegment((InsertStatement)result, (ReturningSegment)optional));
        InsertStatementHandler.getWhereSegment((InsertStatement)sqlStatement).ifPresent(optional -> InsertStatementHandler.setWhereSegment((InsertStatement)result, (WhereSegment)WhereSegmentBinder.bind(optional, insertStatementBinderContext, targetTableBinderContexts, sourceTableBinderContexts)));
        result.addParameterMarkerSegments(sqlStatement.getParameterMarkerSegments());
        result.getCommentSegments().addAll(sqlStatement.getCommentSegments());
        return result;
    }

    private UpdateStatement bindMergeUpdate(UpdateStatement sqlStatement, SimpleTableSegment tableSegment, SQLStatementBinderContext statementBinderContext, Map<String, TableSegmentBinderContext> targetTableBinderContexts, Map<String, TableSegmentBinderContext> sourceTableBinderContexts) {
        UpdateStatement result = (UpdateStatement)sqlStatement.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        result.setTable((TableSegment)tableSegment);
        LinkedList<ColumnAssignmentSegment> assignments = new LinkedList<ColumnAssignmentSegment>();
        SQLStatementBinderContext updateStatementBinderContext = new SQLStatementBinderContext(statementBinderContext.getMetaData(), statementBinderContext.getDefaultDatabaseName(), statementBinderContext.getDatabaseType(), statementBinderContext.getVariableNames());
        updateStatementBinderContext.getExternalTableBinderContexts().putAll(statementBinderContext.getExternalTableBinderContexts());
        updateStatementBinderContext.getExternalTableBinderContexts().putAll(sourceTableBinderContexts);
        for (AssignmentSegment each : sqlStatement.getSetAssignment().getAssignments()) {
            ArrayList columnSegments = new ArrayList(each.getColumns().size());
            each.getColumns().forEach(column -> columnSegments.add(ColumnSegmentBinder.bind(column, SegmentType.SET_ASSIGNMENT, updateStatementBinderContext, targetTableBinderContexts, Collections.emptyMap())));
            ExpressionSegment value = ExpressionSegmentBinder.bind(each.getValue(), SegmentType.SET_ASSIGNMENT, updateStatementBinderContext, targetTableBinderContexts, Collections.emptyMap());
            ColumnAssignmentSegment columnAssignmentSegment = new ColumnAssignmentSegment(each.getStartIndex(), each.getStopIndex(), columnSegments, value);
            assignments.add(columnAssignmentSegment);
        }
        SetAssignmentSegment setAssignmentSegment = new SetAssignmentSegment(sqlStatement.getSetAssignment().getStartIndex(), sqlStatement.getSetAssignment().getStopIndex(), assignments);
        result.setSetAssignment(setAssignmentSegment);
        sqlStatement.getWhere().ifPresent(optional -> result.setWhere(WhereSegmentBinder.bind(optional, updateStatementBinderContext, targetTableBinderContexts, Collections.emptyMap())));
        UpdateStatementHandler.getDeleteWhereSegment((UpdateStatement)sqlStatement).ifPresent(optional -> UpdateStatementHandler.setDeleteWhereSegment((UpdateStatement)result, (WhereSegment)WhereSegmentBinder.bind(optional, updateStatementBinderContext, targetTableBinderContexts, Collections.emptyMap())));
        UpdateStatementHandler.getOrderBySegment((UpdateStatement)sqlStatement).ifPresent(optional -> UpdateStatementHandler.setOrderBySegment((UpdateStatement)result, (OrderBySegment)optional));
        UpdateStatementHandler.getLimitSegment((UpdateStatement)sqlStatement).ifPresent(optional -> UpdateStatementHandler.setLimitSegment((UpdateStatement)result, (LimitSegment)optional));
        UpdateStatementHandler.getWithSegment((UpdateStatement)sqlStatement).ifPresent(optional -> UpdateStatementHandler.setWithSegment((UpdateStatement)result, (WithSegment)optional));
        result.addParameterMarkerSegments(sqlStatement.getParameterMarkerSegments());
        result.getCommentSegments().addAll(sqlStatement.getCommentSegments());
        return result;
    }

    private /* synthetic */ UpdateStatement lambda$bind$1(TableSegment boundedTargetTableSegment, SQLStatementBinderContext statementBinderContext, Map targetTableBinderContexts, Map sourceTableBinderContexts, UpdateStatement optional) {
        return this.bindMergeUpdate(optional, (SimpleTableSegment)boundedTargetTableSegment, statementBinderContext, targetTableBinderContexts, sourceTableBinderContexts);
    }

    private /* synthetic */ InsertStatement lambda$bind$0(TableSegment boundedTargetTableSegment, SQLStatementBinderContext statementBinderContext, Map targetTableBinderContexts, Map sourceTableBinderContexts, InsertStatement optional) {
        return this.bindMergeInsert(optional, (SimpleTableSegment)boundedTargetTableSegment, statementBinderContext, targetTableBinderContexts, sourceTableBinderContexts);
    }
}

