/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement.dml;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shardingsphere.infra.binder.segment.combine.CombineSegmentBinder;
import org.apache.shardingsphere.infra.binder.segment.from.TableSegmentBinder;
import org.apache.shardingsphere.infra.binder.segment.from.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.segment.lock.LockSegmentBinder;
import org.apache.shardingsphere.infra.binder.segment.projection.ProjectionsSegmentBinder;
import org.apache.shardingsphere.infra.binder.segment.where.WhereSegmentBinder;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.LockSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.ModelSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.WindowSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.WithSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.SelectStatementHandler;

public final class SelectStatementBinder
implements SQLStatementBinder<SelectStatement> {
    @Override
    public SelectStatement bind(SelectStatement sqlStatement, ShardingSphereMetaData metaData, String defaultDatabaseName) {
        return this.bind(sqlStatement, metaData, defaultDatabaseName, Collections.emptyMap(), Collections.emptyMap());
    }

    private SelectStatement bind(SelectStatement sqlStatement, ShardingSphereMetaData metaData, String defaultDatabaseName, Map<String, TableSegmentBinderContext> outerTableBinderContexts, Map<String, TableSegmentBinderContext> externalTableBinderContexts) {
        SelectStatement result = (SelectStatement)sqlStatement.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        LinkedHashMap<String, TableSegmentBinderContext> tableBinderContexts = new LinkedHashMap<String, TableSegmentBinderContext>();
        SQLStatementBinderContext statementBinderContext = new SQLStatementBinderContext(metaData, defaultDatabaseName, sqlStatement.getDatabaseType(), sqlStatement.getVariableNames());
        statementBinderContext.getExternalTableBinderContexts().putAll(externalTableBinderContexts);
        TableSegment boundedTableSegment = TableSegmentBinder.bind(sqlStatement.getFrom(), statementBinderContext, tableBinderContexts, outerTableBinderContexts);
        result.setFrom(boundedTableSegment);
        result.setProjections(ProjectionsSegmentBinder.bind(sqlStatement.getProjections(), statementBinderContext, boundedTableSegment, tableBinderContexts, outerTableBinderContexts));
        sqlStatement.getWhere().ifPresent(optional -> result.setWhere(WhereSegmentBinder.bind(optional, statementBinderContext, tableBinderContexts, outerTableBinderContexts)));
        sqlStatement.getGroupBy().ifPresent(arg_0 -> ((SelectStatement)result).setGroupBy(arg_0));
        sqlStatement.getHaving().ifPresent(arg_0 -> ((SelectStatement)result).setHaving(arg_0));
        sqlStatement.getOrderBy().ifPresent(arg_0 -> ((SelectStatement)result).setOrderBy(arg_0));
        sqlStatement.getCombine().ifPresent(optional -> result.setCombine(CombineSegmentBinder.bind(optional, statementBinderContext)));
        SelectStatementHandler.getLimitSegment((SelectStatement)sqlStatement).ifPresent(optional -> SelectStatementHandler.setLimitSegment((SelectStatement)result, (LimitSegment)optional));
        SelectStatementHandler.getLockSegment((SelectStatement)sqlStatement).ifPresent(optional -> SelectStatementHandler.setLockSegment((SelectStatement)result, (LockSegment)LockSegmentBinder.bind(optional, statementBinderContext, tableBinderContexts, outerTableBinderContexts)));
        SelectStatementHandler.getWindowSegment((SelectStatement)sqlStatement).ifPresent(optional -> SelectStatementHandler.setWindowSegment((SelectStatement)result, (WindowSegment)optional));
        SelectStatementHandler.getWithSegment((SelectStatement)sqlStatement).ifPresent(optional -> SelectStatementHandler.setWithSegment((SelectStatement)result, (WithSegment)optional));
        SelectStatementHandler.getModelSegment((SelectStatement)sqlStatement).ifPresent(optional -> SelectStatementHandler.setModelSegment((SelectStatement)result, (ModelSegment)optional));
        result.addParameterMarkerSegments(sqlStatement.getParameterMarkerSegments());
        result.getCommentSegments().addAll(sqlStatement.getCommentSegments());
        return result;
    }

    public SelectStatement bindCorrelateSubquery(SelectStatement sqlStatement, ShardingSphereMetaData metaData, String defaultDatabaseName, Map<String, TableSegmentBinderContext> outerTableBinderContexts, Map<String, TableSegmentBinderContext> externalTableBinderContexts) {
        return this.bind(sqlStatement, metaData, defaultDatabaseName, outerTableBinderContexts, externalTableBinderContexts);
    }

    public SelectStatement bindWithExternalTableContexts(SelectStatement statement, ShardingSphereMetaData metaData, String defaultDatabaseName, Map<String, TableSegmentBinderContext> externalTableContexts) {
        return this.bind(statement, metaData, defaultDatabaseName, Collections.emptyMap(), externalTableContexts);
    }
}

