/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.context.planner;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.sqlfederation.compiler.context.parser.OptimizerParserContext;
import org.apache.shardingsphere.sqlfederation.compiler.context.planner.OptimizerPlannerContext;
import org.apache.shardingsphere.sqlfederation.compiler.metadata.schema.SQLFederationSchema;
import org.apache.shardingsphere.sqlfederation.compiler.planner.util.SQLFederationPlannerUtils;

public final class OptimizerPlannerContextFactory {
    private static final JavaTypeFactory DEFAULT_DATA_TYPE_FACTORY = new JavaTypeFactoryImpl();

    public static Map<String, OptimizerPlannerContext> create(Map<String, ShardingSphereDatabase> databases, Map<String, OptimizerParserContext> parserContexts, SQLParserRule sqlParserRule) {
        ConcurrentHashMap<String, OptimizerPlannerContext> result = new ConcurrentHashMap<String, OptimizerPlannerContext>(databases.size(), 1.0f);
        for (Map.Entry<String, ShardingSphereDatabase> entry : databases.entrySet()) {
            result.put(entry.getKey(), OptimizerPlannerContextFactory.create(entry.getValue(), parserContexts.get(entry.getKey()), sqlParserRule));
        }
        return result;
    }

    public static OptimizerPlannerContext create(ShardingSphereDatabase database, OptimizerParserContext parserContext, SQLParserRule sqlParserRule) {
        LinkedHashMap<String, SqlValidator> validators = new LinkedHashMap<String, SqlValidator>();
        LinkedHashMap<String, SqlToRelConverter> converters = new LinkedHashMap<String, SqlToRelConverter>();
        for (Map.Entry entry : database.getSchemas().entrySet()) {
            CalciteConnectionConfigImpl connectionConfig = new CalciteConnectionConfigImpl(parserContext.getDialectProps());
            SQLFederationSchema sqlFederationSchema = new SQLFederationSchema((String)entry.getKey(), (ShardingSphereSchema)entry.getValue(), database.getProtocolType(), DEFAULT_DATA_TYPE_FACTORY);
            CalciteCatalogReader catalogReader = SQLFederationPlannerUtils.createCatalogReader((String)entry.getKey(), (Schema)sqlFederationSchema, (RelDataTypeFactory)DEFAULT_DATA_TYPE_FACTORY, (CalciteConnectionConfig)connectionConfig);
            SqlValidator validator = SQLFederationPlannerUtils.createSqlValidator(catalogReader, (RelDataTypeFactory)DEFAULT_DATA_TYPE_FACTORY, parserContext.getDatabaseType(), (CalciteConnectionConfig)connectionConfig);
            SqlToRelConverter converter = SQLFederationPlannerUtils.createSqlToRelConverter(catalogReader, validator, SQLFederationPlannerUtils.createRelOptCluster((RelDataTypeFactory)DEFAULT_DATA_TYPE_FACTORY), sqlParserRule, parserContext.getDatabaseType(), true);
            validators.put((String)entry.getKey(), validator);
            converters.put((String)entry.getKey(), converter);
        }
        return new OptimizerPlannerContext(validators, converters);
    }

    @Generated
    private OptimizerPlannerContextFactory() {
    }
}

