/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.converter.segment.expression.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlUnresolvedFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.expression.ExpressionConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.expression.impl.TrimFunctionConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.expression.impl.WindowFunctionConverter;

public class FunctionConverter
implements SQLSegmentConverter<FunctionSegment, SqlNode> {
    @Override
    public Optional<SqlNode> convert(FunctionSegment segment) {
        SqlIdentifier functionName = new SqlIdentifier(segment.getFunctionName(), SqlParserPos.ZERO);
        if ("CURRENT_USER".equalsIgnoreCase(functionName.getSimple())) {
            return Optional.of(functionName);
        }
        if ("TRIM".equalsIgnoreCase(functionName.getSimple())) {
            return new TrimFunctionConverter().convert(segment);
        }
        if ("OVER".equalsIgnoreCase(functionName.getSimple())) {
            return new WindowFunctionConverter().convert(segment);
        }
        LinkedList functions = new LinkedList();
        SqlStdOperatorTable.instance().lookupOperatorOverloads(functionName, null, SqlSyntax.FUNCTION, functions, SqlNameMatchers.withCaseSensitive((boolean)false));
        return Optional.of(functions.isEmpty() ? new SqlBasicCall((SqlOperator)new SqlUnresolvedFunction(functionName, null, null, null, null, SqlFunctionCategory.USER_DEFINED_FUNCTION), this.getFunctionParameters(segment.getParameters()), SqlParserPos.ZERO) : new SqlBasicCall((SqlOperator)functions.iterator().next(), this.getFunctionParameters(segment.getParameters()), SqlParserPos.ZERO));
    }

    private List<SqlNode> getFunctionParameters(Collection<ExpressionSegment> sqlSegments) {
        LinkedList<SqlNode> result = new LinkedList<SqlNode>();
        ExpressionConverter expressionConverter = new ExpressionConverter();
        for (ExpressionSegment each : sqlSegments) {
            expressionConverter.convert(each).ifPresent(optional -> result.addAll(optional instanceof SqlNodeList ? ((SqlNodeList)optional).getList() : Collections.singleton(optional)));
        }
        return result;
    }
}

