/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.converter.segment.expression.impl;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.MatchAgainstExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.expression.ExpressionConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.expression.impl.SQLExtensionOperatorTable;

public final class MatchExpressionConverter
implements SQLSegmentConverter<MatchAgainstExpression, SqlNode> {
    @Override
    public Optional<SqlNode> convert(MatchAgainstExpression segment) {
        LinkedList<Object> sqlNodes = new LinkedList<Object>();
        ArrayList<String> names = new ArrayList<String>();
        if (segment.getColumnName().getOwner().isPresent()) {
            this.addOwnerNames(names, (OwnerSegment)segment.getColumnName().getOwner().get());
        }
        names.add(segment.getColumnName().getIdentifier().getValue());
        sqlNodes.add(new SqlIdentifier(names, SqlParserPos.ZERO));
        new ExpressionConverter().convert(segment.getExpr()).ifPresent(sqlNodes::add);
        SqlCharStringLiteral searchModifier = SqlLiteral.createCharString((String)segment.getSearchModifier(), (SqlParserPos)SqlParserPos.ZERO);
        sqlNodes.add(searchModifier);
        return Optional.of(new SqlBasicCall((SqlOperator)SQLExtensionOperatorTable.MATCH_AGAINST, sqlNodes, SqlParserPos.ZERO));
    }

    private void addOwnerNames(List<String> names, OwnerSegment owner) {
        if (null != owner) {
            this.addOwnerNames(names, owner.getOwner().orElse(null));
            names.add(owner.getIdentifier().getValue());
        }
    }
}

