/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.converter.segment.expression.impl;

import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.UnaryOperationExpression;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.expression.ExpressionConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.expression.impl.SQLExtensionOperatorTable;

public final class UnaryOperationExpressionConverter
implements SQLSegmentConverter<UnaryOperationExpression, SqlNode> {
    private static final Map<String, SqlOperator> REGISTRY = new TreeMap<String, SqlOperator>(String.CASE_INSENSITIVE_ORDER);

    private static void register() {
        UnaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.UNARY_PLUS);
        UnaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.UNARY_MINUS);
        UnaryOperationExpressionConverter.register((SqlOperator)SQLExtensionOperatorTable.TILDE);
    }

    private static void register(SqlOperator sqlOperator) {
        REGISTRY.put(sqlOperator.getName(), sqlOperator);
    }

    @Override
    public Optional<SqlNode> convert(UnaryOperationExpression segment) {
        SqlOperator operator = this.convertOperator(segment);
        List<SqlNode> sqlNodes = this.convertSqlNodes(segment);
        return Optional.of(new SqlBasicCall(operator, sqlNodes, SqlParserPos.ZERO));
    }

    private SqlOperator convertOperator(UnaryOperationExpression segment) {
        String operator = segment.getOperator();
        Preconditions.checkState((boolean)REGISTRY.containsKey(operator), (String)"Unsupported SQL operator: %s", (Object)operator);
        return REGISTRY.get(operator);
    }

    private List<SqlNode> convertSqlNodes(UnaryOperationExpression segment) {
        SqlNode expression = new ExpressionConverter().convert(segment.getExpression()).orElseThrow(IllegalStateException::new);
        LinkedList<SqlNode> result = new LinkedList<SqlNode>();
        result.add(expression);
        return result;
    }

    static {
        UnaryOperationExpressionConverter.register();
    }
}

