/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.converter.segment.from.impl;

import java.util.LinkedList;
import java.util.Optional;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.expression.ExpressionConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.expression.impl.ColumnConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.from.TableConverter;

public final class JoinTableConverter
implements SQLSegmentConverter<JoinTableSegment, SqlNode> {
    @Override
    public Optional<SqlNode> convert(JoinTableSegment segment) {
        SqlNode left = new TableConverter().convert(segment.getLeft()).orElseThrow(IllegalStateException::new);
        SqlNode right = new TableConverter().convert(segment.getRight()).orElseThrow(IllegalStateException::new);
        Optional<SqlNode> condition = this.convertJoinCondition(segment);
        SqlLiteral conditionType = this.convertConditionType(segment);
        SqlLiteral joinType = JoinType.valueOf((String)segment.getJoinType()).symbol(SqlParserPos.ZERO);
        return Optional.of(new SqlJoin(SqlParserPos.ZERO, left, SqlLiteral.createBoolean((boolean)segment.isNatural(), (SqlParserPos)SqlParserPos.ZERO), joinType, right, conditionType, (SqlNode)condition.orElse(null)));
    }

    private SqlLiteral convertConditionType(JoinTableSegment segment) {
        if (!segment.getUsing().isEmpty()) {
            return JoinConditionType.USING.symbol(SqlParserPos.ZERO);
        }
        return null == segment.getCondition() ? JoinConditionType.NONE.symbol(SqlParserPos.ZERO) : JoinConditionType.ON.symbol(SqlParserPos.ZERO);
    }

    private Optional<SqlNode> convertJoinCondition(JoinTableSegment segment) {
        if (null != segment.getCondition()) {
            return new ExpressionConverter().convert(segment.getCondition());
        }
        if (segment.getUsing().isEmpty()) {
            return Optional.empty();
        }
        LinkedList sqlNodes = new LinkedList();
        ColumnConverter columnConverter = new ColumnConverter();
        for (ColumnSegment each : segment.getUsing()) {
            columnConverter.convert(each).ifPresent(sqlNodes::add);
        }
        return Optional.of(new SqlNodeList(sqlNodes, SqlParserPos.ZERO));
    }
}

